/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.model.WeblogicEjbJar;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsJar;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CreateEjbIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = WeblogicBundle.message("intention.text.create.ejb", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/CreateEjbIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/CreateEjbIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        DomElement domElement;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/weblogic/CreateEjbIntention", "isAvailable"));
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        DomFileElement element = DomManager.getDomManager((Project)project).getFileElement((XmlFile)file);
        if (element != null && ((domElement = element.getRootElement()) instanceof WeblogicEjbJar || domElement instanceof WeblogicRdbmsJar)) {
            XmlTag tag = domElement.getXmlTag();
            return tag != null && tag.getTextRange().contains(editor.getCaretModel().getOffset());
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/weblogic/CreateEjbIntention", "invoke"));
        }
        ActionGroup group = EjbHelper.getEjbHelper().createAddEjbActionGroup(EjbModuleUtil.getEjbFacet((PsiElement)file));
        JComponent component = editor.getComponent();
        JBPopupFactory.getInstance().createActionGroupPopup(null, group, DataManager.getInstance().getDataContext((Component)component), JBPopupFactory.ActionSelectionAid.NUMBERING, true).showInCenterOf((Component)component);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

