/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.codeStyle;

import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jdom.Element;

public class PropertiesCodeStyleSettings
extends CustomCodeStyleSettings {
    public static final char[] DELIMITERS = new char[]{'=', ':', ' '};
    public boolean SPACES_AROUND_KEY_VALUE_DELIMITER;
    public boolean KEEP_BLANK_LINES;
    public int KEY_VALUE_DELIMITER_CODE;

    public PropertiesCodeStyleSettings(CodeStyleSettings container) {
        super(PropertiesLanguage.INSTANCE.getID(), container);
    }

    public static PropertiesCodeStyleSettings getInstance(Project project) {
        return (PropertiesCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(PropertiesCodeStyleSettings.class);
    }

    public char getDelimiter() {
        return DELIMITERS[this.KEY_VALUE_DELIMITER_CODE];
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        super.readExternal(parentElement);
        parentElement = parentElement.getChild(this.getTagName());
        if (parentElement != null) {
            Character delimiter = null;
            for (Object o : parentElement.getChildren("option")) {
                Element e = (Element)o;
                String fieldName = e.getAttributeValue("name");
                if (!"KEY_VALUE_DELIMITER".equals(fieldName)) continue;
                String value = e.getAttributeValue("value");
                delimiter = Character.valueOf(value.charAt(0));
                break;
            }
            if (delimiter != null) {
                switch (delimiter.charValue()) {
                    case '=': {
                        this.KEY_VALUE_DELIMITER_CODE = 0;
                        break;
                    }
                    case ':': {
                        this.KEY_VALUE_DELIMITER_CODE = 1;
                        break;
                    }
                    case ' ': {
                        this.KEY_VALUE_DELIMITER_CODE = 2;
                    }
                }
            }
        }
    }
}

