/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleNode
extends ProjectViewNode<ResourceBundle>
implements ValidateableNode,
DropTargetNode {
    public ResourceBundleNode(Project project, ResourceBundle resourceBundle, ViewSettings settings) {
        super(project, (Object)resourceBundle, settings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        List<PropertiesFile> propertiesFiles = ((ResourceBundle)this.getValue()).getPropertiesFiles();
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            PsiFileNode node = new PsiFileNode(this.myProject, propertiesFile.getContainingFile(), this.getSettings());
            children.add((AbstractTreeNode)node);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/projectView/ResourceBundleNode", "getChildren"));
        }
        return arrayList;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/projectView/ResourceBundleNode", "contains"));
        }
        if (!file.isValid()) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
        return propertiesFile != null && ((ResourceBundle)this.getValue()).getPropertiesFiles().contains(propertiesFile);
    }

    public VirtualFile getVirtualFile() {
        List<PropertiesFile> list = ((ResourceBundle)this.getValue()).getPropertiesFiles();
        if (!list.isEmpty()) {
            return list.get(0).getVirtualFile();
        }
        return null;
    }

    public void update(PresentationData presentation) {
        presentation.setIcon(AllIcons.Nodes.ResourceBundle);
        presentation.setPresentableText(PropertiesBundle.message("project.view.resource.bundle.tree.node.text", ((ResourceBundle)this.getValue()).getBaseName()));
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.getProject(), (VirtualFile)new ResourceBundleAsVirtualFile((ResourceBundle)this.getValue()));
        FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(descriptor, requestFocus);
    }

    public boolean isSortByFirstChild() {
        return true;
    }

    public Comparable getTypeSortKey() {
        return new PsiFileNode.ExtensionSortKey(StdFileTypes.PROPERTIES.getDefaultExtension());
    }

    public boolean validate() {
        ResourceBundle currentBundle;
        if (!super.validate()) {
            return false;
        }
        ResourceBundle newBundle = ((ResourceBundle)this.getValue()).getDefaultPropertiesFile().getResourceBundle();
        if (!Comparing.equal((Object)newBundle, (Object)(currentBundle = (ResourceBundle)this.getValue()))) {
            return false;
        }
        return !(currentBundle instanceof ResourceBundleImpl) || ((ResourceBundleImpl)currentBundle).isValid();
    }

    public boolean isValid() {
        return ((ResourceBundle)this.getValue()).getDefaultPropertiesFile().getContainingFile().isValid();
    }

    public boolean canDrop(TreeNode[] sourceNodes) {
        for (TreeNode node : sourceNodes) {
            if (ResourceBundleNode.extractPropertiesFileFromNode(node) != null) continue;
            return false;
        }
        return true;
    }

    public void drop(TreeNode[] sourceNodes, DataContext dataContext) {
        MultiMap bundleGrouping = new MultiMap();
        for (TreeNode sourceNode : sourceNodes) {
            PropertiesFile propertiesFile = ResourceBundleNode.extractPropertiesFileFromNode(sourceNode);
            if (propertiesFile == null) {
                return;
            }
            bundleGrouping.putValue((Object)propertiesFile.getResourceBundle(), (Object)propertiesFile);
        }
        ResourceBundle resourceBundle = (ResourceBundle)this.getValue();
        bundleGrouping.remove((Object)resourceBundle);
        ResourceBundleManager resourceBundleManager = ResourceBundleManager.getInstance(this.myProject);
        ArrayList<PropertiesFile> toAddInResourceBundle = new ArrayList<PropertiesFile>();
        for (Map.Entry entry : bundleGrouping.entrySet()) {
            toAddInResourceBundle.addAll((Collection)entry.getValue());
            ResourceBundle currentBundle = (ResourceBundle)entry.getKey();
            Collection propertiesFilesToMove = (Collection)entry.getValue();
            if (currentBundle.getPropertiesFiles().size() - propertiesFilesToMove.size() <= 0) continue;
            String currentBundleBaseName = currentBundle.getBaseName();
            ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>(currentBundle.getPropertiesFiles());
            files.removeAll(propertiesFilesToMove);
            resourceBundleManager.dissociateResourceBundle(currentBundle);
            resourceBundleManager.combineToResourceBundle(files, currentBundleBaseName);
        }
        toAddInResourceBundle.addAll(resourceBundle.getPropertiesFiles());
        String baseName = resourceBundle.getBaseName();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
        fileEditorManager.closeFile((VirtualFile)new ResourceBundleAsVirtualFile(resourceBundle));
        resourceBundleManager.dissociateResourceBundle(resourceBundle);
        ResourceBundle updatedBundle = resourceBundleManager.combineToResourceBundleAndGet(toAddInResourceBundle, baseName);
        FileEditorManager.getInstance((Project)this.myProject).openFile((VirtualFile)new ResourceBundleAsVirtualFile(updatedBundle), true);
        ProjectView.getInstance((Project)this.myProject).refresh();
    }

    public void dropExternalFiles(PsiFileSystemItem[] sourceFileArray, DataContext dataContext) {
    }

    @Nullable
    private static PropertiesFile extractPropertiesFileFromNode(TreeNode node) {
        if (!(node instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
        if (!(userObject instanceof PsiFileNode)) {
            return null;
        }
        PsiFile file = (PsiFile)((PsiFileNode)userObject).getValue();
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
        if (propertiesFile == null || !file.getManager().isInProject((PsiElement)file) || !file.isValid()) {
            return null;
        }
        return propertiesFile;
    }
}

