/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleEditorProvider
extends FileTypeFactory
implements FileEditorProvider,
DumbAware {
    private static final ResourceBundleFileType RESOURCE_BUNDLE_FILE_TYPE = new ResourceBundleFileType();

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "accept"));
        }
        if (file instanceof ResourceBundleAsVirtualFile) {
            return true;
        }
        if (!file.isValid()) {
            return false;
        }
        FileType type = file.getFileType();
        if (type != StdFileTypes.PROPERTIES && type != StdFileTypes.XML) {
            return false;
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "lambda$accept$0"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "lambda$accept$0"));
            }
            return PsiManager.getInstance((Project)project).findFile(file);
        });
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
        return propertiesFile != null && propertiesFile.getResourceBundle().getPropertiesFiles().size() > 1;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        ResourceBundle resourceBundle;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "createEditor"));
        }
        if (file instanceof ResourceBundleAsVirtualFile) {
            resourceBundle = ((ResourceBundleAsVirtualFile)file).getResourceBundle();
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                throw new IllegalArgumentException("psifile cannot be null");
            }
            resourceBundle = PropertiesImplUtil.getPropertiesFile(psiFile).getResourceBundle();
        }
        ResourceBundleEditor resourceBundleEditor = new ResourceBundleEditor(resourceBundle);
        if (resourceBundleEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "createEditor"));
        }
        return resourceBundleEditor;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "readState"));
        }
        ResourceBundleEditor.ResourceBundleEditorState resourceBundleEditorState = new ResourceBundleEditor.ResourceBundleEditorState(null);
        if (resourceBundleEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "readState"));
        }
        return resourceBundleEditorState;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    @NotNull
    public String getEditorTypeId() {
        if ("ResourceBundle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "getEditorTypeId"));
        }
        return "ResourceBundle";
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/properties/editor/ResourceBundleEditorProvider", "createFileTypes"));
        }
        consumer.consume((FileType)RESOURCE_BUNDLE_FILE_TYPE, "");
    }
}

