/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.RemovePropertyFix;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemovePropertyLocalFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.RemovePropertyLocalFix");
    public static final RemovePropertyLocalFix INSTANCE = new RemovePropertyLocalFix();

    @NotNull
    public String getFamilyName() {
        String string = PropertiesBundle.message("remove.property.quick.fix.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/RemovePropertyLocalFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/RemovePropertyLocalFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/properties/RemovePropertyLocalFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class, (boolean)false);
        if (property == null) {
            return;
        }
        try {
            new RemovePropertyFix(property).invoke(project, null, property.getPropertiesFile().getContainingFile());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

