/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public interface BundleNameEvaluator {
    public static final BundleNameEvaluator DEFAULT = new BundleNameEvaluator(){

        @Override
        @Nullable
        public String evaluateBundleName(final PsiFile psiFile) {
            PsiDirectory directory = (PsiDirectory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory>(){

                public PsiDirectory compute() {
                    return psiFile.getParent();
                }
            });
            if (directory == null) {
                return null;
            }
            String packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory);
            if (packageQualifiedName == null) {
                return null;
            }
            StringBuilder qName = new StringBuilder(packageQualifiedName);
            if (qName.length() > 0) {
                qName.append(".");
            }
            qName.append(ResourceBundleManager.getInstance(psiFile.getProject()).getBaseName(psiFile));
            return qName.toString();
        }
    };
    public static final BundleNameEvaluator BASE_NAME = new BundleNameEvaluator(){

        @Override
        @Nullable
        public String evaluateBundleName(PsiFile psiFile) {
            return ResourceBundleManager.getInstance(psiFile.getProject()).getBaseName(psiFile);
        }
    };

    @Nullable
    public String evaluateBundleName(PsiFile var1);
}

