/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSUtils {
    @NonNls
    public static final String VALUE = "value";

    private RSUtils() {
    }

    @NotNull
    public static String getResourcePath(@NotNull RSHttpMethod httpMethod) {
        RSJamPsiMethodPath methodPathResource;
        RSJamPsiClassPath psiClassPath;
        if (httpMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "httpMethod", "com/intellij/ws/rest/utils/RSUtils", "getResourcePath"));
        }
        StringBuilder buffer = new StringBuilder();
        PsiMethod psiMethod = httpMethod.getPsiElement();
        JamService service = JamService.getJamService((Project)psiMethod.getProject());
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass != null && (psiClassPath = (RSJamPsiClassPath)service.getJamElement((PsiElement)containingClass, new JamMemberMeta[]{RSJamPsiClassPath.META})) != null) {
            buffer.append(psiClassPath.getResourceValue());
        }
        if ((methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{RSJamPsiMethodPath.META})) != null) {
            buffer.append(methodPathResource.getResourceValue());
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/utils/RSUtils", "getResourcePath"));
        }
        return string;
    }

    public static boolean isResourceClass(@NotNull PsiClass resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/ws/rest/utils/RSUtils", "isResourceClass"));
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)resource, (String)"javax.ws.rs.Path", (boolean)true);
    }

    @Nullable
    public static PsiClass getParent(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/ws/rest/utils/RSUtils", "getParent"));
        }
        for (PsiElement el = anno.getParent(); el != null; el = el.getParent()) {
            if (!(el instanceof PsiClass)) continue;
            return (PsiClass)el;
        }
        return null;
    }

    public static boolean isNonAbstractAndPublicClass(PsiClass c) {
        PsiModifierList modifiers = c == null ? null : c.getModifierList();
        return modifiers != null && !c.isAnnotationType() && !c.isEnum() && !c.isInterface() && !modifiers.hasExplicitModifier("abstract") && modifiers.hasExplicitModifier("public");
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/ws/rest/utils/RSUtils", "getAnnotationValue"));
        }
        return (String)AnnotationModelUtil.getStringValue((PsiAnnotation)anno, (String)VALUE, null).getValue();
    }

    public static String[] getAllMimes(Project project) {
        ArrayListSet types = new ArrayListSet();
        for (PsiAnnotation produce : RSUtils.getAnnotations(project, "javax.ws.rs.ProduceMime", "javax.ws.rs.ConsumeMime", "javax.ws.rs.Produces", "javax.ws.rs.Consumes")) {
            List values = AnnotationModelUtil.getStringArrayValue((PsiAnnotation)produce, (String)VALUE);
            for (AnnotationGenericValue value : values) {
                types.add(value.getValue());
            }
        }
        return ArrayUtil.toStringArray((Collection)types);
    }

    @NotNull
    private static Collection<PsiAnnotation> getAnnotations(@NotNull Project project, String ... fqns) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/utils/RSUtils", "getAnnotations"));
        }
        LinkedList annos = ContainerUtilRt.newLinkedList();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        for (String fqn : fqns) {
            String shortName = StringUtil.getShortName((String)fqn);
            for (PsiAnnotation psiAnnotation : JavaAnnotationIndex.getInstance().get(shortName, project, scope)) {
                if (!fqn.equals(psiAnnotation.getQualifiedName())) continue;
                annos.add(psiAnnotation);
            }
        }
        LinkedList linkedList = annos;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/utils/RSUtils", "getAnnotations"));
        }
        return linkedList;
    }

    public static boolean isResourceMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ws/rest/utils/RSUtils", "isResourceMethod"));
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, Arrays.asList("javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.PUT", "javax.ws.rs.DELETE", "javax.ws.rs.HEAD"));
    }

    @Nullable
    public static PsiClass findInheritorClassAnnotatedAs(@NotNull @NonNls String fqn, @NotNull PsiClass c) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/ws/rest/utils/RSUtils", "findInheritorClassAnnotatedAs"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ws/rest/utils/RSUtils", "findInheritorClassAnnotatedAs"));
        }
        Query query = ClassInheritorsSearch.search((PsiClass)c, (SearchScope)GlobalSearchScope.projectScope((Project)c.getProject()), (boolean)true);
        Collection classes = query.findAll();
        for (PsiClass clazz : classes) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (String[])new String[]{fqn}) != null) {
                return clazz;
            }
            PsiClass cl = RSUtils.findInheritorClassAnnotatedAs(fqn, clazz);
            if (cl == null) continue;
            return cl;
        }
        return null;
    }

    public static boolean isRootResourceClass(PsiElement element) {
        return element instanceof PsiClass && RSUtils.isNonAbstractAndPublicClass((PsiClass)element) && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)element), (String)"javax.ws.rs.Path", (boolean)true);
    }

    public static void annotateFieldWithPathParam(Project project, PsiField field, String name) {
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(field.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiAnnotation annotation = factory.createAnnotationFromText("@javax.ws.rs.PathParam(\"" + name + "\")", (PsiElement)field);
        PsiElement firstChild = modifierList.getFirstChild();
        if (firstChild != null) {
            modifierList.addBefore((PsiElement)annotation, firstChild);
        } else {
            modifierList.add((PsiElement)annotation);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
    }

    public static boolean isRestLibAttached(Module module) {
        return RSUtils.isRestLibAttached(module, "javax.ws.rs.Path");
    }

    public static boolean isRestLibAttached(Module module, String requiredClassName) {
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(requiredClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    @NotNull
    public static List<String> findPathParamNames(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/ws/rest/utils/RSUtils", "findPathParamNames"));
        }
        ArrayList variants = ContainerUtil.newArrayList();
        String path = (String)AnnotationModelUtil.getStringValue((PsiAnnotation)annotation, (String)VALUE, null).getValue();
        try {
            variants.addAll(new UriTemplateParser(path).getNames());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/utils/RSUtils", "findPathParamNames"));
        }
        return arrayList;
    }
}

