/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.references.WSReferenceProvider;
import com.intellij.ws.rest.references.MimeReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MimeReferenceProvider
extends WSReferenceProvider {
    private static final PsiJavaElementPattern.Capture<PsiLiteralExpression> PATTERN = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().insideAnnotationParam((ElementPattern)StandardPatterns.string().oneOf(new String[]{"javax.ws.rs.Produces", "javax.ws.rs.Consumes"}));

    public ElementPattern<? extends PsiElement> getPattern() {
        return PATTERN;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        List charSequences;
        Object text;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/rest/references/MimeReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ws/rest/references/MimeReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiLiteralExpression && (text = ((PsiLiteralExpression)element).getValue()) instanceof String && (charSequences = StringUtil.split((String)((String)text), (String)";")).size() > 0) {
            String str = (String)charSequences.get(0);
            TextRange range = TextRange.from((int)element.getText().indexOf(str), (int)str.length());
            ElementManipulators.getManipulator((PsiElement)element).getRangeInElement(element);
            PsiReference[] psiReferenceArray = new PsiReference[]{new MimeReference((PsiLiteralExpression)element, range)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/MimeReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/MimeReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

