/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.model.dom.wadl;

import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.ws.rest.model.dom.wadl.Application;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WadlDomFileDescription
extends DomFileDescription<Application> {
    public WadlDomFileDescription() {
        super(Application.class, "application", new String[0]);
    }

    protected void initializeFileDescription() {
        this.registerNamespacePollicies();
    }

    private void registerNamespacePollicies() {
        this.registerNamespacePolicy("WADL namespace key", new String[]{"http://wadl.dev.java.net/2009/02"});
    }

    @NotNull
    public List<String> getAllowedNamespaces(@NotNull String namespaceKey, @NotNull XmlFile file) {
        if (namespaceKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceKey", "com/intellij/ws/rest/model/dom/wadl/WadlDomFileDescription", "getAllowedNamespaces"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ws/rest/model/dom/wadl/WadlDomFileDescription", "getAllowedNamespaces"));
        }
        List<String> stringList = super.getAllowedNamespaces(namespaceKey, file);
        List<String> list = stringList.isEmpty() ? Collections.singletonList(namespaceKey) : stringList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/model/dom/wadl/WadlDomFileDescription", "getAllowedNamespaces"));
        }
        return list;
    }
}

