/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.inspections.fixes.ChangeMethodReturnTypeFix;
import org.jetbrains.annotations.NotNull;

public class VoidMethodMarkedWithGETInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkMethod(@NotNull PsiMethod method, @NotNull ProblemsHolder problemsHolder, @NotNull Module module) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ws/rest/inspections/VoidMethodMarkedWithGETInspection", "checkMethod"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/ws/rest/inspections/VoidMethodMarkedWithGETInspection", "checkMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/VoidMethodMarkedWithGETInspection", "checkMethod"));
        }
        PsiType type = method.getReturnType();
        PsiTypeElement typeElement = method.getReturnTypeElement();
        if (PsiType.VOID.equals((Object)type) && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"javax.ws.rs.GET", (boolean)true) && typeElement != null && !VoidMethodMarkedWithGETInspection.isSuspendedMethod(method)) {
            problemsHolder.registerProblem((PsiElement)typeElement, RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ChangeMethodReturnTypeFix((PsiType)PsiType.getJavaLangString((PsiManager)method.getManager(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)method.getProject())), RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.fix.name", new Object[0]))});
        }
    }

    private static boolean isSuspendedMethod(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ws/rest/inspections/VoidMethodMarkedWithGETInspection", "isSuspendedMethod"));
        }
        for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
            PsiType type;
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"javax.ws.rs.container.Suspended", (boolean)true) || !((type = parameter.getType()) instanceof PsiClassType) || !InheritanceUtil.isInheritor((PsiClass)((PsiClassType)type).resolve(), (String)"javax.ws.rs.container.AsyncResponse")) continue;
            return true;
        }
        return false;
    }

    protected void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/VoidMethodMarkedWithGETInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.short.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/VoidMethodMarkedWithGETInspection", "getShortName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return false;
    }
}

