/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.ws.inspections.fixes.RemoveElementFix;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ValidMimeAnnotationInspection
extends AbstractRestJavaInspection {
    @NonNls
    private static final Pattern myPattern = Pattern.compile("[^\\p{Cc}^\\s]+/[^\\p{Cc}^\\s]+");

    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder problemsHolder, @NotNull Module module) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/ws/rest/inspections/ValidMimeAnnotationInspection", "checkMethod"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/ws/rest/inspections/ValidMimeAnnotationInspection", "checkMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/ValidMimeAnnotationInspection", "checkMethod"));
        }
        PsiModifierList modifiers = psiMethod.getModifierList();
        if (modifiers == null) {
            return;
        }
        ValidMimeAnnotationInspection.checkMime(modifiers.findAnnotation("javax.ws.rs.ConsumeMime"), problemsHolder);
        ValidMimeAnnotationInspection.checkMime(modifiers.findAnnotation("javax.ws.rs.Consumes"), problemsHolder);
        ValidMimeAnnotationInspection.checkMime(modifiers.findAnnotation("javax.ws.rs.ProduceMime"), problemsHolder);
        ValidMimeAnnotationInspection.checkMime(modifiers.findAnnotation("javax.ws.rs.Produces"), problemsHolder);
    }

    private static void checkMime(PsiAnnotation anno, ProblemsHolder problemsHolder) {
        if (anno == null) {
            return;
        }
        String mime = RSUtils.getAnnotationValue(anno);
        PsiNameValuePair[] attrs = anno.getParameterList().getAttributes();
        if (mime == null || attrs.length == 0) {
            return;
        }
        if (!myPattern.matcher(mime).matches()) {
            problemsHolder.registerProblem((PsiElement)attrs[0], RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.problem", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[]{new RemoveElementFix((PsiElement)attrs[0], RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.fix", new Object[0]))});
        }
    }

    protected void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/ValidMimeAnnotationInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.short.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/ValidMimeAnnotationInspection", "getShortName"));
        }
        return string;
    }
}

