/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.utils.WsPsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RestWrongDefaultValueInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        PsiParameter[] parameters;
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection", "checkMethod"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection", "checkMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection", "checkMethod"));
        }
        for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
            RestWrongDefaultValueInspection.check((PsiVariable)parameter, holder);
        }
    }

    @Override
    protected void checkFields(@NotNull PsiField field, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection", "checkFields"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection", "checkFields"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection", "checkFields"));
        }
        RestWrongDefaultValueInspection.check((PsiVariable)field, holder);
    }

    private static void check(PsiVariable variable, ProblemsHolder problems) {
        if (variable.getType() instanceof PsiPrimitiveType) {
            PsiAnnotation anno;
            PsiPrimitiveType type = (PsiPrimitiveType)variable.getType();
            PsiModifierList modifierList = variable.getModifierList();
            if (modifierList != null && (anno = modifierList.findAnnotation("javax.ws.rs.DefaultValue")) != null) {
                String value = WsPsiUtil.getAnnotationValue((PsiAnnotation)anno);
                PsiAnnotationMemberValue problemElement = anno.findAttributeValue("value");
                if (value != null && problemElement != null && !RestWrongDefaultValueInspection.canConvert(value, type)) {
                    problems.registerProblem((PsiElement)problemElement, RSBundle.message("cant.convert.to", type.getPresentableText()), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                }
            }
        }
    }

    private static boolean canConvert(String s, PsiPrimitiveType type) {
        try {
            if (PsiPrimitiveType.BOOLEAN.equals((Object)type)) {
                return s.equals("true") || s.equals("false");
            }
            if (PsiType.BYTE.equals((Object)type)) {
                Byte.parseByte(s);
            } else if (PsiPrimitiveType.SHORT.equals((Object)type)) {
                Short.parseShort(s);
            } else if (PsiPrimitiveType.INT.equals((Object)type)) {
                Integer.parseInt(s);
            } else if (PsiPrimitiveType.LONG.equals((Object)type)) {
                Long.parseLong(s);
            } else if (PsiPrimitiveType.DOUBLE.equals((Object)type)) {
                Double.parseDouble(s);
            } else if (PsiPrimitiveType.FLOAT.equals((Object)type)) {
                Float.parseFloat(s);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("@DefaultValue issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection", "getDisplayName"));
        }
        return "@DefaultValue issues";
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection", "getShortName"));
        }
        return string;
    }
}

