/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiParameterPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestPathParamCompletion
extends CompletionContributor {
    private static final PsiParameterPattern ANNOTATED_WITH_PATH_PARAM = (PsiParameterPattern)PsiJavaPatterns.psiParameter().withAnnotation("javax.ws.rs.PathParam");
    private static final PsiJavaElementPattern.Capture<PsiLiteralExpression> PATH_PARAM_VALUE = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().insideAnnotationParam((ElementPattern)StandardPatterns.string().oneOf(new String[]{"javax.ws.rs.PathParam"}), "value");

    public RestPathParamCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement().withParent((ElementPattern)ANNOTATED_WITH_PATH_PARAM), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                String value;
                PsiAnnotation annotation;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ws/rest/completion/RestPathParamCompletion$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ws/rest/completion/RestPathParamCompletion$1", "addCompletions"));
                }
                PsiElement position = parameters.getOriginalPosition();
                if (position instanceof PsiIdentifier && position.getTextLength() > 0) {
                    return;
                }
                PsiElement elementContext = parameters.getPosition().getContext();
                if (!(elementContext instanceof PsiParameter)) {
                    return;
                }
                PsiModifierList modifierList = ((PsiParameter)elementContext).getModifierList();
                if (modifierList != null && (annotation = modifierList.findAnnotation("javax.ws.rs.PathParam")) != null && (value = (String)AnnotationModelUtil.getStringValue((PsiAnnotation)annotation, (String)"value", null).getValue()) != null && value.length() > 0) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)value));
                    result.stopHere();
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement().withParent(PATH_PARAM_VALUE), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement psiElement;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ws/rest/completion/RestPathParamCompletion$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ws/rest/completion/RestPathParamCompletion$2", "addCompletions"));
                }
                PsiElement originalPosition = parameters.getOriginalPosition();
                if (originalPosition != null && (psiElement = originalPosition.getContext()) instanceof PsiLiteralExpression) {
                    for (String pathParamValue : RestPathParamCompletion.findPathAnnotationValue(psiElement)) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)pathParamValue));
                    }
                    result.stopHere();
                }
            }
        });
    }

    private static List<String> findPathAnnotationValue(PsiElement el) {
        ArrayList<String> variants = new ArrayList<String>();
        PsiAnnotation annotation = null;
        while (el != null) {
            PsiModifierList modifierList;
            if (el instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)el;
                annotation = method.getModifierList().findAnnotation("javax.ws.rs.Path");
            }
            if (el instanceof PsiClass && (modifierList = ((PsiClass)el).getModifierList()) != null) {
                annotation = modifierList.findAnnotation("javax.ws.rs.Path");
            }
            if (annotation != null) {
                variants.addAll(RSUtils.findPathParamNames(annotation));
                annotation = null;
            }
            if (!((el = el.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return variants;
    }
}

