/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianMavenLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.ui.AddLibraryAction;
import icons.MavenIcons;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class AddMavenDependencyAction
extends AddLibraryAction {
    @NotNull
    private final Project project;
    @NotNull
    private final JComponent parentComponent;

    public AddMavenDependencyAction(@NotNull Project project, @NotNull JComponent parentComponent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/jboss/arquillian/configuration/ui/AddMavenDependencyAction", "<init>"));
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/plugins/jboss/arquillian/configuration/ui/AddMavenDependencyAction", "<init>"));
        }
        super(MavenIcons.MavenLogo, ArquillianBundle.message("arquillian.action.add.maven.dependency", new Object[0]));
        this.project = project;
        this.parentComponent = parentComponent;
    }

    @Override
    Collection<ArquillianLibraryModel> execute() {
        NewLibraryConfiguration configuration = RepositoryAttachHandler.chooseLibraryAndDownload((Project)this.project, null, (JComponent)this.parentComponent);
        if (configuration != null) {
            RepositoryLibraryProperties libraryProperties = (RepositoryLibraryProperties)configuration.getProperties();
            return Collections.singletonList(new ArquillianMavenLibraryModel(libraryProperties.getGroupId(), libraryProperties.getArtifactId(), libraryProperties.getVersion()));
        }
        return Collections.emptyList();
    }
}

