/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianExistLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianListModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianMavenLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianModelCreator;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianExistLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.ConfigurationSpecificState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerModel;
import com.intellij.util.containers.hash.HashMap;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianContainerModel
extends ArquillianListModel<ArquillianLibraryState, ArquillianLibraryModel, ArquillianContainerState, ArquillianContainerModel> {
    private final Project project;
    private final ArquillianContainer arquillianContainer;
    @NotNull
    private String name;
    @NotNull
    private String jvmParameters;
    @NotNull
    Map<String, String> envVariables = new HashMap();
    @NotNull
    RemoteDebuggerModel remoteDebuggerModel;

    public ArquillianContainerModel(Project project, String name, ArquillianContainer arquillianContainer) {
        this(project, arquillianContainer.createDefaultState(project, name), arquillianContainer);
    }

    public ArquillianContainerModel(final Project project, ArquillianContainerState state, ArquillianContainer arquillianContainer) {
        super(state, new ArquillianModelCreator<ArquillianLibraryState, ArquillianLibraryModel>(){

            @Override
            public ArquillianLibraryModel createModel(ArquillianLibraryState libraryState) {
                return libraryState.accept(new ArquillianLibraryState.Visitor<ArquillianLibraryModel>(){

                    @Override
                    public ArquillianLibraryModel visitMavenLibrary(ArquillianMavenLibraryState state) {
                        return new ArquillianMavenLibraryModel(state);
                    }

                    @Override
                    public ArquillianLibraryModel visitExistLibrary(ArquillianExistLibraryState state) {
                        return new ArquillianExistLibraryModel(project, state);
                    }
                });
            }
        });
        this.project = project;
        this.arquillianContainer = arquillianContainer;
        this.name = state.getName();
        this.jvmParameters = state.getJvmParameters();
        this.setEnvVariables(state.getEnvVariables());
        this.remoteDebuggerModel = new RemoteDebuggerModel(project, state.getRemoteDebuggerState());
        this.remoteDebuggerModel.addChangeListener(new ArquillianModel.Listener<ConfigurationSpecificState, RemoteDebuggerModel>(){

            @Override
            public void itemChanged(RemoteDebuggerModel model) {
                ArquillianContainerModel.this.notifyMeChanged();
            }
        });
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel", "setName"));
        }
        this.name = name;
        this.notifyMeChanged();
    }

    @NotNull
    public String getJvmParameters() {
        String string = this.jvmParameters;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel", "getJvmParameters"));
        }
        return string;
    }

    public void setJvmParameters(@NotNull String jvmParameters) {
        if (jvmParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmParameters", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel", "setJvmParameters"));
        }
        this.jvmParameters = jvmParameters;
        this.notifyMeChanged();
    }

    @NotNull
    public Map<String, String> getEnvVariables() {
        Map<String, String> map = this.envVariables;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel", "getEnvVariables"));
        }
        return map;
    }

    public void setEnvVariables(@NotNull Map<String, String> envVariables) {
        if (envVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envVariables", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel", "setEnvVariables"));
        }
        this.envVariables.clear();
        this.envVariables.putAll(envVariables);
        this.notifyMeChanged();
    }

    @NotNull
    public RemoteDebuggerModel getRemoteDebuggerModel() {
        RemoteDebuggerModel remoteDebuggerModel = this.remoteDebuggerModel;
        if (remoteDebuggerModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel", "getRemoteDebuggerModel"));
        }
        return remoteDebuggerModel;
    }

    @Nullable
    public Icon getIcon() {
        return this.arquillianContainer.getIcon();
    }

    @NotNull
    public ArquillianContainer getDescription() {
        ArquillianContainer arquillianContainer = this.arquillianContainer;
        if (arquillianContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel", "getDescription"));
        }
        return arquillianContainer;
    }

    @Override
    public boolean hasChanges(ArquillianContainerState state) {
        return !this.jvmParameters.equals(state.getJvmParameters()) || !this.name.equals(state.getName()) || !this.envVariables.equals(state.getEnvVariables()) || this.remoteDebuggerModel.hasChanges(state.getRemoteDebuggerState()) || super.hasChanges(state);
    }

    @Override
    public ArquillianContainerState getCurrentState() {
        return new ArquillianContainerState(this.arquillianContainer.getId(), this.name, this.getChildrenStates(), this.jvmParameters, this.envVariables, this.remoteDebuggerModel.getCurrentState());
    }

    public static class ScopeNameComparator
    implements Comparator<ArquillianContainerModel> {
        @Override
        public int compare(ArquillianContainerModel o1, ArquillianContainerModel o2) {
            ArquillianContainer.Scope scope2;
            ArquillianContainer.Scope scope1 = o1.getDescription().getScope();
            return scope1 == (scope2 = o2.getDescription().getScope()) ? StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true) : scope1.compareTo(scope2);
        }
    }
}

