/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLPlainTextImpl
extends YAMLScalarImpl
implements YAMLScalar {
    public YAMLPlainTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        int myStart = this.getTextOffset();
        ASTNode node = this.getNode();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        boolean seenText = false;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == YAMLTokenTypes.TEXT) {
                seenText = true;
                result.add(child.getTextRange().shiftRight(-myStart));
                continue;
            }
            if (child.getElementType() != YAMLTokenTypes.EOL) continue;
            if (!seenText) {
                result.add(child.getTextRange().shiftRight(-myStart));
            }
            seenText = false;
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getContentRanges"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges, int indexBefore) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getRangesJoiner"));
        }
        if (contentRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRanges", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getRangesJoiner"));
        }
        if (YAMLPlainTextImpl.isNewline(text, contentRanges.get(indexBefore)) || YAMLPlainTextImpl.isNewline(text, contentRanges.get(indexBefore + 1))) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getRangesJoiner"));
            }
            return "";
        }
        if (" " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getRangesJoiner"));
        }
        return " ";
    }

    private static boolean isNewline(@NotNull CharSequence text, @NotNull TextRange range) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "isNewline"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "isNewline"));
        }
        return range.getLength() == 1 && text.charAt(range.getStartOffset()) == '\n';
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getEncodeReplacements"));
        }
        YAMLPlainTextImpl.checkForConsistency(input);
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int currentLength = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\n') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n\n" + indentString)));
                currentLength = 0;
                continue;
            }
            if (currentLength > 60 && input.charAt(i) == ' ' && YAMLPlainTextImpl.isSurroundedByNoSpace(input, i)) {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n" + indentString)));
                currentLength = 0;
                continue;
            }
            ++currentLength;
        }
        return result;
    }

    private static void checkForConsistency(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "checkForConsistency"));
        }
        if (input.length() == 0) {
            throw new IllegalArgumentException("Cannot be empty");
        }
        if (!YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(0)) || !YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(input.length() - 1))) {
            throw new IllegalArgumentException("Cannot have leading or trailing whitespaces");
        }
        char firstChar = input.charAt(0);
        if ((firstChar != '?' && firstChar != ':' && firstChar != '-' || input.length() <= 1 || !YAMLGrammarCharUtil.isPlainSafe(input.charAt(1))) && YAMLGrammarCharUtil.isIndicatorChar(firstChar)) {
            throw new IllegalArgumentException("Could not start with indicator chars");
        }
        for (int i = 1; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\n' && !YAMLPlainTextImpl.isSurroundedByNoSpace(input, i)) {
                throw new IllegalArgumentException("Could not form line with leading/trailing whitespace");
            }
            if (YAMLGrammarCharUtil.isSpaceLike(c) || YAMLGrammarCharUtil.isPlainSafe(c) && c != ':' && c != '#' || c == '#' && YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(i - 1)) || c == ':' && i + 1 < input.length() && YAMLGrammarCharUtil.isPlainSafe(input.charAt(i + 1))) continue;
            throw new IllegalArgumentException("Restricted characters appeared");
        }
    }

    @Override
    public String toString() {
        return "YAML plain scalar text";
    }

    @Override
    public boolean isMultiline() {
        return this.getNode().findChildByType((IElementType)YAMLTokenTypes.EOL) != null;
    }
}

