/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WsPsiUtil {
    private static final PsiConstantEvaluationHelperImpl CONSTANT_EVALUATOR = new PsiConstantEvaluationHelperImpl();

    private WsPsiUtil() {
    }

    @Nullable
    public static PsiClass findClass(@NotNull String clazz, @NotNull Project project, @Nullable GlobalSearchScope scope) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/ws/utils/WsPsiUtil", "findClass"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/utils/WsPsiUtil", "findClass"));
        }
        return JavaPsiFacade.getInstance((Project)project).findClass(clazz, scope != null ? scope : GlobalSearchScope.allScope((Project)project));
    }

    public static boolean processProperties(PsiClass clazz, PsiElementProcessor<PsiMember> processor) {
        for (PsiMethod m : clazz.getAllMethods()) {
            if (!PropertyUtil.isSimplePropertyGetter((PsiMethod)m) || processor.execute((PsiElement)m)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation annotation, @NonNls String attr) {
        Object o;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/ws/utils/WsPsiUtil", "getAnnotationValue"));
        }
        PsiAnnotationMemberValue value = annotation.findAttributeValue(attr);
        if (value instanceof PsiExpression && (o = CONSTANT_EVALUATOR.computeConstantExpression((PsiElement)value)) instanceof String) {
            return (String)o;
        }
        return null;
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/ws/utils/WsPsiUtil", "getAnnotationValue"));
        }
        return WsPsiUtil.getAnnotationValue(annotation, "value");
    }
}

