/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GwtTestsClassLoader
extends ClassLoader {
    private final Set myIgnoredUrls;

    public GwtTestsClassLoader(ClassLoader parent) {
        super(parent);
        String ignoredUrlsProperty = System.getProperty("idea.gwt.ignored.resource.urls");
        if (ignoredUrlsProperty == null || ignoredUrlsProperty.length() == 0) {
            this.myIgnoredUrls = Collections.EMPTY_SET;
        } else {
            this.myIgnoredUrls = new HashSet();
            String[] ignoredUrls = ignoredUrlsProperty.split("\n");
            int len = ignoredUrls.length;
            for (int i = 0; i < len; ++i) {
                this.myIgnoredUrls.add(ignoredUrls[i]);
            }
        }
    }

    public Enumeration getResources(String name) throws IOException {
        ArrayList<URL> list;
        Enumeration<URL> resources = super.getResources(name);
        if ("META-INF/jdoconfig.xml".equals(name) && (list = Collections.list(resources)).size() > 1) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                URL url = (URL)iterator.next();
                if (!this.myIgnoredUrls.contains(url.toString())) continue;
                iterator.remove();
            }
            return Collections.enumeration(list);
        }
        return resources;
    }
}

