/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.actions.DiagramDefaultAddElementAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.beans.UserDefinedClassWrapper;
import com.intellij.spring.perspectives.diagrams.edges.SpringNavigatableEdge;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringDiagramExtras
extends DiagramExtras<SpringElementWrapper> {
    public Object getData(String dataId, List<DiagramNode<SpringElementWrapper>> diagramNodes, DiagramBuilder builder) {
        List edges;
        SpringBeanPointer pointer;
        SpringElementWrapper wrapper;
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return super.getData(dataId, diagramNodes, builder);
        }
        if (diagramNodes != null && diagramNodes.size() == 1 && (wrapper = (SpringElementWrapper)diagramNodes.get(0).getIdentifyingElement()) instanceof SpringBeanPointerWrapper && (pointer = (SpringBeanPointer)((SpringBeanPointerWrapper)wrapper).getWrapped()).isValid()) {
            PsiElement navigatable = pointer.getPsiElement();
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return navigatable;
            }
        }
        if ((edges = DiagramUtils.getSelectedEdges((DiagramBuilder)builder)).size() == 1) {
            DiagramEdge edge = (DiagramEdge)edges.get(0);
            PsiElement psiElement = null;
            if (edge instanceof SpringNavigatableEdge) {
                psiElement = ((SpringNavigatableEdge)edge).getIdentifyingPsiElement();
            }
            if (psiElement != null && CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiElement;
            }
        }
        return super.getData(dataId, diagramNodes, builder);
    }

    public DiagramAddElementAction getAddElementHandler() {
        return new DiagramDefaultAddElementAction(){

            @NotNull
            protected Object convertElement(@NotNull Object element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/perspectives/diagrams/SpringDiagramExtras$1", "convertElement"));
                }
                if (element instanceof PsiClass) {
                    UserDefinedClassWrapper userDefinedClassWrapper = new UserDefinedClassWrapper((PsiClass)element);
                    if (userDefinedClassWrapper == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/perspectives/diagrams/SpringDiagramExtras$1", "convertElement"));
                    }
                    return userDefinedClassWrapper;
                }
                Object object = super.convertElement(element);
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/perspectives/diagrams/SpringDiagramExtras$1", "convertElement"));
                }
                return object;
            }
        };
    }

    public String suggestDiagramFileName(SpringElementWrapper element) {
        return element.getName();
    }

    public DiagramDnDProvider<SpringElementWrapper> getDnDProvider() {
        return new DiagramDnDProvider<SpringElementWrapper>(){

            public boolean isAcceptedForDnD(Object o, Project project) {
                return SpringDiagramExtras.isConcreteClass(o);
            }

            public SpringElementWrapper[] wrapToModelObject(Object o, Project project) {
                return new SpringElementWrapper[]{new UserDefinedClassWrapper((PsiClass)o)};
            }
        };
    }

    private static boolean isConcreteClass(Object o) {
        return o instanceof PsiClass && !((PsiClass)o).isInterface() && !((PsiClass)o).isEnum() && !((PsiClass)o).hasModifierProperty("abstract");
    }
}

