/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class FileClob
implements Clob,
Serializable {
    private final File myFile;
    private final String myCharset;
    private transient int myLength;

    public FileClob(@NotNull File file, String charset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/remote/jdbc/impl/FileClob", "<init>"));
        }
        this.myFile = file;
        this.myCharset = charset;
    }

    public long length() throws SQLException {
        if (this.myLength < 1 && this.myFile.length() > 0L) {
            InputStreamReader reader = this.getCharacterStream();
            try {
                this.myLength = FileClob.position(reader, Long.MAX_VALUE);
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.myLength;
    }

    private static int position(InputStreamReader reader, long maxValue) throws IOException {
        int read;
        int count = 0;
        long curMax = maxValue;
        char[] buf = new char[1024];
        while ((read = reader.read(buf, 0, (int)Math.min((long)buf.length, curMax))) > 0) {
            count += read;
            curMax -= (long)read;
        }
        return count;
    }

    public String getSubString(long pos, int length) throws SQLException {
        InputStreamReader reader = this.getCharacterStream();
        try {
            FileClob.position(reader, pos - 1L);
            return new String(FileUtilRt.loadText((Reader)reader, (int)length));
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }

    public InputStreamReader getCharacterStream() throws SQLException {
        try {
            FileInputStream stream = new FileInputStream(this.myFile);
            return this.myCharset == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, this.myCharset);
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        final InputStreamReader reader = this.getCharacterStream();
        return new InputStream(){

            public int read() throws IOException {
                return reader.read();
            }

            public void close() throws IOException {
                reader.close();
            }
        };
    }

    public long position(String searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public long position(Clob searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public int setString(long pos, String str) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void free() throws SQLException {
    }

    public Reader getCharacterStream(long pos, final long length) throws SQLException {
        final InputStreamReader reader = this.getCharacterStream();
        if (pos <= 1L && length == this.length()) {
            return reader;
        }
        try {
            FileClob.position(reader, pos - 1L);
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        return new Reader(){
            long avail;
            {
                this.avail = length;
            }

            public int read(char[] cbuf, int off, int len) throws IOException {
                long min = Math.min((long)len, this.avail);
                this.avail -= (long)len;
                return reader.read(cbuf, off, (int)min);
            }

            public void close() throws IOException {
                reader.close();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileClob fileClob = (FileClob)o;
        return this.myFile.equals(fileClob.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }
}

