/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtGradleSdkPaths
implements GwtSdkPaths {
    @NonNls
    public static final String TYPE_ID = "gradle";
    private final String myBasePath;
    private final String myVersion;
    private final String myDevDirPath;

    public GwtGradleSdkPaths(String homeDirectoryPath, String version) {
        this.myDevDirPath = homeDirectoryPath;
        this.myBasePath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)homeDirectoryPath));
        this.myVersion = version;
    }

    @NotNull
    public static String getSdkUrl(@NotNull String pathToGwtJar, boolean fromMaven) {
        if (pathToGwtJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToGwtJar", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getSdkUrl"));
        }
        File gwtJar = new File(pathToGwtJar);
        File gwtJarDir = fromMaven ? gwtJar.getParentFile() : gwtJar.getParentFile().getParentFile();
        String version = gwtJarDir.getName();
        File gwtDevDir = new File(gwtJarDir.getParentFile().getParentFile(), "gwt-dev/" + version);
        String string = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)gwtDevDir.getAbsolutePath()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getSdkUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDevJarPath(boolean systemIndependent) {
        String string = this.getArtifactPath("gwt-dev");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getDevJarPath"));
        }
        return string;
    }

    @NotNull
    private String getArtifactPath(String name) {
        String path = GwtGradleSdkPaths.getArtifactPath(new File(this.myBasePath), name, this.myVersion, null);
        if (path != null) {
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getArtifactPath"));
            }
            return string;
        }
        String string = new File(this.myBasePath, name + "/" + this.myVersion).getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getArtifactPath"));
        }
        return string;
    }

    @Override
    public String getCodeServerJarPath() {
        return this.getArtifactPath("gwt-codeserver");
    }

    @Override
    @NotNull
    public String getHomeDirectoryUrl() {
        String string = JpsPathUtil.pathToUrl((String)this.myDevDirPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getHomeDirectoryUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getServletJarPath() {
        String string = this.getArtifactPath("gwt-servlet");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getServletJarPath"));
        }
        return string;
    }

    @Nullable
    private static String getArtifactPath(@NotNull File baseDir, @NotNull String name, @NotNull String version, @Nullable String suffix) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getArtifactPath"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getArtifactPath"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getArtifactPath"));
        }
        File[] subDirs = new File(baseDir, name + "/" + version).listFiles();
        if (subDirs != null) {
            for (File subDir : subDirs) {
                File jar = new File(subDir, name + "-" + version + (suffix != null ? "-" + suffix : "") + ".jar");
                if (!jar.exists()) continue;
                return jar.getAbsolutePath();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getUserJarPath() {
        String string = this.getArtifactPath("gwt-user");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getUserJarPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getAdditionalCompilerJars() {
        String preferredVersion;
        ArrayList<String> additionalJars = new ArrayList<String>();
        ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath("javax.validation", "validation-api", null, null));
        ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath("javax.validation", "validation-api", null, "sources"));
        if (VersionComparatorUtil.compare((String)this.myVersion, (String)"2.7.0") >= 0) {
            for (String[] dependency : GwtSdkPathUtil.DEFAULT_ADDITIONAL_2_7_DEPENDENCIES) {
                preferredVersion = dependency.length > 2 ? dependency[2] : null;
                ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath(dependency[0], dependency[1], preferredVersion, null));
            }
        }
        if (VersionComparatorUtil.compare((String)this.myVersion, (String)"2.8.0-beta1") > 0) {
            for (String[] dependency : GwtSdkPathUtil.DEFAULT_ADDITIONAL_2_8_DEPENDENCIES) {
                preferredVersion = dependency.length > 2 ? dependency[2] : null;
                ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath(dependency[0], dependency[1], preferredVersion, null));
            }
        }
        ArrayList<String> arrayList = additionalJars;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getAdditionalCompilerJars"));
        }
        return arrayList;
    }

    @Nullable
    private String getArtifactPath(@NotNull String groupId, @NotNull String artifactId, @Nullable String preferredVersion, @Nullable String suffix) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getArtifactPath"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/jps/gwt/model/impl/sdk/GwtGradleSdkPaths", "getArtifactPath"));
        }
        File dir = new File(PathUtilRt.getParentPath((String)this.myBasePath), groupId);
        String[] dirNames = new File(dir, artifactId).list();
        if (dirNames != null && dirNames.length > 0) {
            String path;
            if (preferredVersion != null && ArrayUtil.contains((String)preferredVersion, (String[])dirNames) && (path = GwtGradleSdkPaths.getArtifactPath(dir, artifactId, preferredVersion, suffix)) != null) {
                return path;
            }
            String version = Collections.max(Arrays.asList(dirNames), VersionComparatorUtil.COMPARATOR);
            return GwtGradleSdkPaths.getArtifactPath(dir, artifactId, version, suffix);
        }
        return null;
    }
}

