/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl;

import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gwt.index.JpsGwtModuleIndex;
import org.jetbrains.jps.gwt.index.impl.JpsGwtModuleIndexImpl;
import org.jetbrains.jps.gwt.model.JpsGwtExtensionService;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.gwt.model.impl.JpsGwtModuleExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsGwtExtensionServiceImpl
extends JpsGwtExtensionService {
    private final ConcurrentMap<JpsModel, JpsGwtModuleIndex> myCachedGwtIndices = ContainerUtil.newConcurrentMap();

    @Override
    @Nullable
    public JpsGwtModuleExtension getExtension(@Nullable JpsModule module) {
        return module != null ? (JpsGwtModuleExtension)module.getContainer().getChild(JpsGwtModuleExtensionImpl.ROLE) : null;
    }

    @Override
    public void setExtension(@NotNull JpsModule module, @NotNull JpsGwtModuleExtension extension) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/gwt/model/impl/JpsGwtExtensionServiceImpl", "setExtension"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/gwt/model/impl/JpsGwtExtensionServiceImpl", "setExtension"));
        }
        module.getContainer().setChild(JpsGwtModuleExtensionImpl.ROLE, (JpsElement)extension);
    }

    @Override
    @NotNull
    public JpsGwtModuleIndex getGwtModuleIndex(@NotNull JpsModel model, @NotNull BuildDataPaths paths) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/gwt/model/impl/JpsGwtExtensionServiceImpl", "getGwtModuleIndex"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jps/gwt/model/impl/JpsGwtExtensionServiceImpl", "getGwtModuleIndex"));
        }
        JpsGwtModuleIndex index = (JpsGwtModuleIndex)this.myCachedGwtIndices.get(model);
        if (index == null) {
            index = new JpsGwtModuleIndexImpl(model, paths);
            this.myCachedGwtIndices.put(model, index);
        }
        JpsGwtModuleIndex jpsGwtModuleIndex = index;
        if (jpsGwtModuleIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtExtensionServiceImpl", "getGwtModuleIndex"));
        }
        return jpsGwtModuleIndex;
    }

    public void clearCache() {
        this.myCachedGwtIndices.clear();
    }
}

