/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.hibernate.CriteriaApiReferenceProvider;
import com.intellij.hibernate.HibernateMessages;
import com.intellij.hibernate.model.HibernateConstants;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import java.text.MessageFormat;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CriteriaApiResolveInspection
extends BaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "CriteriaApiResolveInspection";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = HibernateConstants.HIBERNATE_INSPECTIONS_GROUP;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = HibernateMessages.message("inspection.name.hibernate.criteria.api", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                CriteriaApiResolveInspection.checkQueryApiReferences(expression, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/CriteriaApiResolveInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void checkQueryApiReferences(PsiLiteralExpression literalExpression, ProblemsHolder holder, boolean isOnTheFly) {
        JpaUtil.processReferencesOfType((PsiReference[])literalExpression.getReferences(), CriteriaApiReferenceProvider.CriteriaAttributeReference.class, reference -> {
            boolean badResolve;
            boolean bl = badResolve = reference.resolve() == null;
            if (badResolve) {
                String message = MessageFormat.format(reference.getUnresolvedMessagePattern(), reference.getCanonicalText());
                holder.registerProblem(holder.getManager().createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, reference.getQuickFixes()));
                return false;
            }
            return true;
        });
    }
}

