/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.compiler;

import com.intellij.flex.compiler.CommandLineArgumentsTokenizer;
import com.intellij.flex.compiler.CompilationThread;
import com.intellij.flex.compiler.MessageSender;
import com.intellij.flex.compiler.OutputLogger;
import com.intellij.flex.compiler.SdkSpecificHandler;
import com.intellij.flex.compiler.flex3.Flex3Handler;
import com.intellij.flex.compiler.flex4.Flex4Handler;
import flex2.tools.VersionInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class FlexCompiler
implements MessageSender {
    private static final String CONNECTION_SUCCESSFUL = "Connection successful";
    private static final String FINISH_COMMAND = "Finish";
    public static final String CANCEL_COMMAND = "Cancel";
    public static final String COMPILATION_FINISHED = "Compilation finished";
    public static String SDK_MAJOR_VERSION = VersionInfo.FLEX_MAJOR_VERSION;
    public static String SDK_MINOR_VERSION = VersionInfo.FLEX_MINOR_VERSION;
    public static String SDK_REVISION_VERSION = VersionInfo.FLEX_NANO_VERSION;
    private DataInputStream myDataInputStream;
    private DataOutputStream myDataOutputStream;

    private void openSocket(int port) throws IOException {
        int maxAttempts = 10;
        for (int i = 0; i < 10; ++i) {
            try {
                Socket socket = new Socket(InetAddress.getLocalHost(), port);
                this.myDataInputStream = new DataInputStream(socket.getInputStream());
                this.myDataOutputStream = new DataOutputStream(socket.getOutputStream());
                System.out.println(CONNECTION_SUCCESSFUL);
                break;
            }
            catch (IOException e) {
                if (i == 9) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore2) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public static void main(String[] args) {
        int port;
        if (args.length != 1) {
            System.out.println("Missing port parameter");
        }
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.out.println("Incorrect port parameter");
            return;
        }
        try {
            FlexCompiler flexCompiler = new FlexCompiler();
            flexCompiler.openSocket(port);
            flexCompiler.processInput();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void sendMessage(String message) {
        try {
            this.myDataOutputStream.writeUTF(message.replace('\n', ' ').replace('\r', ' ').trim() + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processInput() throws IOException {
        boolean finish;
        StringBuilder buffer = new StringBuilder();
        do {
            String line = this.myDataInputStream.readUTF();
            buffer.append(line);
        } while (!(finish = this.processCommands(buffer)));
    }

    private boolean processCommands(StringBuilder buffer) {
        int index;
        while ((index = buffer.indexOf("\n")) > -1) {
            String command = buffer.substring(0, index);
            buffer.delete(0, index + 1);
            if (CANCEL_COMMAND.equals(command)) {
                this.cancelAllCompilations();
                continue;
            }
            if (FINISH_COMMAND.equals(command)) {
                this.exit();
                return true;
            }
            this.startCompilationThread(command);
        }
        return false;
    }

    private void startCompilationThread(String command) {
        int colonPos = command.indexOf(":");
        if (colonPos <= 0) {
            this.sendMessage("Error: Incorrect command: [" + command + "]");
            this.sendMessage(COMPILATION_FINISHED);
            return;
        }
        String commandNumberStr = command.substring(0, colonPos);
        try {
            Integer.parseInt(commandNumberStr);
        }
        catch (NumberFormatException e) {
            this.sendMessage("Error: Incorrect command number: [" + commandNumberStr + "]");
            this.sendMessage(COMPILATION_FINISHED);
            return;
        }
        String compilationCommand = command.substring(colonPos + 1);
        boolean isSwf = compilationCommand.startsWith("mxmlc ");
        if (!isSwf && !compilationCommand.startsWith("compc")) {
            this.sendMessage("Error: Incorrect compilation command: [" + compilationCommand + "]");
            this.sendMessage(COMPILATION_FINISHED);
            return;
        }
        String logMessagePrefix = commandNumberStr + ":";
        OutputLogger logger = new OutputLogger(this, logMessagePrefix);
        SdkSpecificHandler sdkSpecificHandler = this.getSdkSpecificHandler();
        if (sdkSpecificHandler == null) {
            logger.log("Error: Flex SDK " + SDK_MAJOR_VERSION + '.' + SDK_MINOR_VERSION + '.' + SDK_REVISION_VERSION + " is not supported by built-in compiler shell. Please change compiler at File | Settings | Compiler | Flex Compiler.");
            logger.log(COMPILATION_FINISHED);
            return;
        }
        CompilationThread compilationThread = new CompilationThread(isSwf, sdkSpecificHandler, FlexCompiler.getParams(compilationCommand), logger);
        compilationThread.setPriority(10);
        compilationThread.setDaemon(true);
        compilationThread.start();
    }

    private SdkSpecificHandler getSdkSpecificHandler() {
        if ("3".equals(SDK_MAJOR_VERSION)) {
            return new Flex3Handler();
        }
        if ("4".equals(SDK_MAJOR_VERSION)) {
            return new Flex4Handler();
        }
        return null;
    }

    private static String[] getParams(String command) {
        CommandLineArgumentsTokenizer tokenizer = new CommandLineArgumentsTokenizer(command);
        tokenizer.nextToken();
        String[] params = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            params[i++] = tokenizer.nextToken();
        }
        return params;
    }

    private void exit() {
        this.cancelAllCompilations();
        try {
            this.myDataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void cancelAllCompilations() {
    }
}

