/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.java.AbstractCucumberJavaExtension;
import org.jetbrains.plugins.cucumber.java.steps.JavaStepDefinition;
import org.jetbrains.plugins.cucumber.java.steps.JavaStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class CucumberJavaExtension
extends AbstractCucumberJavaExtension {
    public static final String CUCUMBER_RUNTIME_JAVA_STEP_DEF_ANNOTATION = "cucumber.runtime.java.StepDefAnnotation";

    @NotNull
    public BDDFrameworkType getStepFileType() {
        BDDFrameworkType bDDFrameworkType = new BDDFrameworkType((FileType)JavaFileType.INSTANCE);
        if (bDDFrameworkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/CucumberJavaExtension", "getStepFileType"));
        }
        return bDDFrameworkType;
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        JavaStepDefinitionCreator javaStepDefinitionCreator = new JavaStepDefinitionCreator();
        if (javaStepDefinitionCreator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/CucumberJavaExtension", "getStepDefinitionCreator"));
        }
        return javaStepDefinitionCreator;
    }

    public List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/cucumber/java/CucumberJavaExtension", "loadStepsFor"));
        }
        GlobalSearchScope dependenciesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        PsiClass stepDefAnnotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(CUCUMBER_RUNTIME_JAVA_STEP_DEF_ANNOTATION, dependenciesScope);
        if (stepDefAnnotationClass == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        Query stepDefAnnotations = AnnotatedElementsSearch.searchPsiClasses((PsiClass)stepDefAnnotationClass, (SearchScope)dependenciesScope);
        for (PsiClass annotationClass : stepDefAnnotations) {
            if (!annotationClass.isAnnotationType()) continue;
            Query javaStepDefinitions = AnnotatedElementsSearch.searchPsiMethods((PsiClass)annotationClass, (SearchScope)dependenciesScope);
            for (PsiMethod stepDefMethod : javaStepDefinitions) {
                result.add(new JavaStepDefinition((PsiElement)stepDefMethod));
            }
        }
        return result;
    }
}

