/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.image.PixelConverter;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.OGLBlitLoops;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLDrawImage;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLMaskBlit;
import sun.java2d.opengl.OGLMaskFill;
import sun.java2d.opengl.OGLPaints;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLRenderer;
import sun.java2d.opengl.OGLSurfaceDataProxy;
import sun.java2d.opengl.OGLTextRenderer;
import sun.java2d.pipe.ParallelogramPipe;
import sun.java2d.pipe.PixelToParallelogramConverter;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.hw.AccelSurface;
import sun.security.action.GetPropertyAction;

public abstract class OGLSurfaceData
extends SurfaceData
implements AccelSurface {
    public static final int PBUFFER = 2;
    public static final int FBOBJECT = 5;
    public static final int PF_INT_ARGB = 0;
    public static final int PF_INT_ARGB_PRE = 1;
    public static final int PF_INT_RGB = 2;
    public static final int PF_INT_RGBX = 3;
    public static final int PF_INT_BGR = 4;
    public static final int PF_INT_BGRX = 5;
    public static final int PF_USHORT_565_RGB = 6;
    public static final int PF_USHORT_555_RGB = 7;
    public static final int PF_USHORT_555_RGBX = 8;
    public static final int PF_BYTE_GRAY = 9;
    public static final int PF_USHORT_GRAY = 10;
    public static final int PF_3BYTE_BGR = 11;
    private static final String DESC_OPENGL_SURFACE = "OpenGL Surface";
    private static final String DESC_OPENGL_SURFACE_RTT = "OpenGL Surface (render-to-texture)";
    private static final String DESC_OPENGL_TEXTURE = "OpenGL Texture";
    static final SurfaceType OpenGLSurface = SurfaceType.Any.deriveSubType("OpenGL Surface", PixelConverter.ArgbPre.instance);
    static final SurfaceType OpenGLSurfaceRTT = OpenGLSurface.deriveSubType("OpenGL Surface (render-to-texture)");
    static final SurfaceType OpenGLTexture = SurfaceType.Any.deriveSubType("OpenGL Texture");
    private static boolean isFBObjectEnabled;
    private static boolean isLCDShaderEnabled;
    private static boolean isBIOpShaderEnabled;
    private static boolean isGradShaderEnabled;
    private OGLGraphicsConfig graphicsConfig;
    protected int type;
    private int nativeWidth;
    private int nativeHeight;
    protected static OGLRenderer oglRenderPipe;
    protected static PixelToParallelogramConverter oglTxRenderPipe;
    protected static ParallelogramPipe oglAAPgramPipe;
    protected static OGLTextRenderer oglTextPipe;
    protected static OGLDrawImage oglImagePipe;

    protected native boolean initTexture(long var1, boolean var3, boolean var4, boolean var5, int var6, int var7);

    protected native boolean initFBObject(long var1, boolean var3, boolean var4, boolean var5, int var6, int var7);

    protected native boolean initFlipBackbuffer(long var1);

    protected abstract boolean initPbuffer(long var1, long var3, boolean var5, int var6, int var7);

    private native int getTextureTarget(long var1);

    private native int getTextureID(long var1);

    protected OGLSurfaceData(OGLGraphicsConfig oGLGraphicsConfig, ColorModel colorModel, int n) {
        super(OGLSurfaceData.getCustomSurfaceType(n), colorModel);
        this.graphicsConfig = oGLGraphicsConfig;
        this.type = n;
        this.setBlitProxyKey(oGLGraphicsConfig.getProxyKey());
    }

    @Override
    public SurfaceDataProxy makeProxyFor(SurfaceData surfaceData) {
        return OGLSurfaceDataProxy.createProxy(surfaceData, this.graphicsConfig);
    }

    private static SurfaceType getCustomSurfaceType(int n) {
        switch (n) {
            case 3: {
                return OpenGLTexture;
            }
            case 5: {
                return OpenGLSurfaceRTT;
            }
        }
        return OpenGLSurface;
    }

    private void initSurfaceNow(int n, int n2) {
        boolean bl = this.getTransparency() == 1;
        boolean bl2 = false;
        switch (this.type) {
            case 2: {
                bl2 = this.initPbuffer(this.getNativeOps(), this.graphicsConfig.getNativeConfigInfo(), bl, n, n2);
                break;
            }
            case 3: {
                bl2 = this.initTexture(this.getNativeOps(), bl, this.isTexNonPow2Available(), this.isTexRectAvailable(), n, n2);
                break;
            }
            case 5: {
                bl2 = this.initFBObject(this.getNativeOps(), bl, this.isTexNonPow2Available(), this.isTexRectAvailable(), n, n2);
                break;
            }
            case 4: {
                bl2 = this.initFlipBackbuffer(this.getNativeOps());
                break;
            }
        }
        if (!bl2) {
            throw new OutOfMemoryError("can't create offscreen surface");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSurface(final int n, final int n2) {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            switch (this.type) {
                case 2: 
                case 3: 
                case 5: {
                    OGLContext.setScratchSurface(this.graphicsConfig);
                    break;
                }
            }
            oGLRenderQueue.flushAndInvokeNow(new Runnable(){

                @Override
                public void run() {
                    OGLSurfaceData.this.initSurfaceNow(n, n2);
                }
            });
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    @Override
    public final OGLContext getContext() {
        return this.graphicsConfig.getContext();
    }

    final OGLGraphicsConfig getOGLGraphicsConfig() {
        return this.graphicsConfig;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    public final int getTextureTarget() {
        return this.getTextureTarget(this.getNativeOps());
    }

    public final int getTextureID() {
        return this.getTextureID(this.getNativeOps());
    }

    @Override
    public long getNativeResource(int n) {
        if (n == 3) {
            return this.getTextureID();
        }
        return 0L;
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        throw new InternalError("not implemented yet");
    }

    @Override
    public boolean canRenderLCDText(SunGraphics2D sunGraphics2D) {
        return this.graphicsConfig.isCapPresent(131072) && sunGraphics2D.paintState <= 0 && (sunGraphics2D.compositeState <= 0 || sunGraphics2D.compositeState <= 1 && this.canHandleComposite(sunGraphics2D.composite));
    }

    private boolean canHandleComposite(Composite composite) {
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            return alphaComposite.getRule() == 3 && alphaComposite.getAlpha() >= 1.0f;
        }
        return false;
    }

    @Override
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        TextPipe textPipe;
        boolean bl = false;
        if (sunGraphics2D.compositeState <= 0 && sunGraphics2D.paintState <= 1 || sunGraphics2D.compositeState == 1 && sunGraphics2D.paintState <= 1 && ((AlphaComposite)sunGraphics2D.composite).getRule() == 3 || sunGraphics2D.compositeState == 2 && sunGraphics2D.paintState <= 1) {
            textPipe = oglTextPipe;
        } else {
            super.validatePipe(sunGraphics2D);
            textPipe = sunGraphics2D.textpipe;
            bl = true;
        }
        PixelToParallelogramConverter pixelToParallelogramConverter = null;
        OGLRenderer oGLRenderer = null;
        if (sunGraphics2D.antialiasHint != 2) {
            if (sunGraphics2D.paintState <= 1) {
                if (sunGraphics2D.compositeState <= 2) {
                    pixelToParallelogramConverter = oglTxRenderPipe;
                    oGLRenderer = oglRenderPipe;
                }
            } else if (sunGraphics2D.compositeState <= 1 && OGLPaints.isValid(sunGraphics2D)) {
                pixelToParallelogramConverter = oglTxRenderPipe;
                oGLRenderer = oglRenderPipe;
            }
        } else if (sunGraphics2D.paintState <= 1) {
            if (this.graphicsConfig.isCapPresent(256) && (sunGraphics2D.imageComp == CompositeType.SrcOverNoEa || sunGraphics2D.imageComp == CompositeType.SrcOver)) {
                if (!bl) {
                    super.validatePipe(sunGraphics2D);
                    bl = true;
                }
                PixelToParallelogramConverter pixelToParallelogramConverter2 = new PixelToParallelogramConverter(sunGraphics2D.shapepipe, oglAAPgramPipe, 0.125, 0.499, false);
                sunGraphics2D.drawpipe = pixelToParallelogramConverter2;
                sunGraphics2D.fillpipe = pixelToParallelogramConverter2;
                sunGraphics2D.shapepipe = pixelToParallelogramConverter2;
            } else if (sunGraphics2D.compositeState == 2) {
                pixelToParallelogramConverter = oglTxRenderPipe;
                oGLRenderer = oglRenderPipe;
            }
        }
        if (pixelToParallelogramConverter != null) {
            if (sunGraphics2D.transformState >= 3) {
                sunGraphics2D.drawpipe = pixelToParallelogramConverter;
                sunGraphics2D.fillpipe = pixelToParallelogramConverter;
            } else if (sunGraphics2D.strokeState != 0) {
                sunGraphics2D.drawpipe = pixelToParallelogramConverter;
                sunGraphics2D.fillpipe = oGLRenderer;
            } else {
                sunGraphics2D.drawpipe = oGLRenderer;
                sunGraphics2D.fillpipe = oGLRenderer;
            }
            sunGraphics2D.shapepipe = pixelToParallelogramConverter;
        } else if (!bl) {
            super.validatePipe(sunGraphics2D);
        }
        sunGraphics2D.textpipe = textPipe;
        sunGraphics2D.imagepipe = oglImagePipe;
    }

    @Override
    protected MaskFill getMaskFill(SunGraphics2D sunGraphics2D) {
        if (!(sunGraphics2D.paintState <= 1 || OGLPaints.isValid(sunGraphics2D) && this.graphicsConfig.isCapPresent(16))) {
            return null;
        }
        return super.getMaskFill(sunGraphics2D);
    }

    @Override
    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (sunGraphics2D.transformState < 3 && sunGraphics2D.compositeState < 2) {
            oglRenderPipe.copyArea(sunGraphics2D, n += sunGraphics2D.transX, n2 += sunGraphics2D.transY, n3, n4, n5, n6);
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        this.invalidate();
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.setScratchSurface(this.graphicsConfig);
            RenderBuffer renderBuffer = oGLRenderQueue.getBuffer();
            oGLRenderQueue.ensureCapacityAndAlignment(12, 4);
            renderBuffer.putInt(72);
            renderBuffer.putLong(this.getNativeOps());
            oGLRenderQueue.flushNow();
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dispose(long l, long l2) {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.setScratchSurface(l2);
            RenderBuffer renderBuffer = oGLRenderQueue.getBuffer();
            oGLRenderQueue.ensureCapacityAndAlignment(12, 4);
            renderBuffer.putInt(73);
            renderBuffer.putLong(l);
            oGLRenderQueue.flushNow();
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void swapBuffers(long l) {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            RenderBuffer renderBuffer = oGLRenderQueue.getBuffer();
            oGLRenderQueue.ensureCapacityAndAlignment(12, 4);
            renderBuffer.putInt(80);
            renderBuffer.putLong(l);
            oGLRenderQueue.flushNow();
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    boolean isTexNonPow2Available() {
        return this.graphicsConfig.isCapPresent(32);
    }

    boolean isTexRectAvailable() {
        return this.graphicsConfig.isCapPresent(0x100000);
    }

    @Override
    public Rectangle getNativeBounds() {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            Rectangle rectangle = new Rectangle(this.nativeWidth, this.nativeHeight);
            return rectangle;
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    boolean isOnScreen() {
        return this.getType() == 1;
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.opengl.fbobject"));
            isFBObjectEnabled = !"false".equals(string);
            String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.opengl.lcdshader"));
            isLCDShaderEnabled = !"false".equals(string2);
            String string3 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.opengl.biopshader"));
            isBIOpShaderEnabled = !"false".equals(string3);
            String string4 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.opengl.gradshader"));
            isGradShaderEnabled = !"false".equals(string4);
            OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
            oglImagePipe = new OGLDrawImage();
            oglTextPipe = new OGLTextRenderer(oGLRenderQueue);
            oglRenderPipe = new OGLRenderer(oGLRenderQueue);
            if (GraphicsPrimitive.tracingEnabled()) {
                oglTextPipe = oglTextPipe.traceWrap();
            }
            oglAAPgramPipe = oglRenderPipe.getAAParallelogramPipe();
            oglTxRenderPipe = new PixelToParallelogramConverter(oglRenderPipe, oglRenderPipe, 1.0, 0.25, true);
            OGLBlitLoops.register();
            OGLMaskFill.register();
            OGLMaskBlit.register();
        }
    }
}

