/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.JavaSecurityAccess;
import sun.misc.JavaSecurityProtectionDomainAccess;
import sun.misc.SharedSecrets;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public class ProtectionDomain {
    private CodeSource codesource;
    private ClassLoader classloader;
    private Principal[] principals;
    private PermissionCollection permissions;
    private boolean hasAllPerm = false;
    private boolean staticPermissions;
    final Key key = new Key();
    private static final Debug debug;

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
            if (permissionCollection instanceof Permissions && ((Permissions)permissionCollection).allPermission != null) {
                this.hasAllPerm = true;
            }
        }
        this.classloader = null;
        this.principals = new Principal[0];
        this.staticPermissions = true;
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
            if (permissionCollection instanceof Permissions && ((Permissions)permissionCollection).allPermission != null) {
                this.hasAllPerm = true;
            }
        }
        this.classloader = classLoader;
        this.principals = principalArray != null ? (Principal[])principalArray.clone() : new Principal[]{};
        this.staticPermissions = false;
    }

    public final CodeSource getCodeSource() {
        return this.codesource;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])this.principals.clone();
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    public boolean implies(Permission permission) {
        if (this.hasAllPerm) {
            return true;
        }
        if (!this.staticPermissions && Policy.getPolicyNoCheck().implies(this, permission)) {
            return true;
        }
        if (this.permissions != null) {
            return this.permissions.implies(permission);
        }
        return false;
    }

    boolean impliesCreateAccessControlContext() {
        return this.implies(SecurityConstants.CREATE_ACC_PERMISSION);
    }

    public String toString() {
        Serializable serializable;
        String string = "<no principals>";
        if (this.principals != null && this.principals.length > 0) {
            serializable = new StringBuilder("(principals ");
            for (int i = 0; i < this.principals.length; ++i) {
                ((StringBuilder)serializable).append(this.principals[i].getClass().getName() + " \"" + this.principals[i].getName() + "\"");
                if (i < this.principals.length - 1) {
                    ((StringBuilder)serializable).append(",\n");
                    continue;
                }
                ((StringBuilder)serializable).append(")\n");
            }
            string = ((StringBuilder)serializable).toString();
        }
        serializable = Policy.isSet() && ProtectionDomain.seeAllp() ? this.mergePermissions() : this.getPermissions();
        return "ProtectionDomain  " + this.codesource + "\n " + this.classloader + "\n " + string + "\n " + serializable + "\n";
    }

    private static boolean seeAllp() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return true;
        }
        if (debug != null) {
            if (securityManager.getClass().getClassLoader() == null && Policy.getPolicyNoCheck().getClass().getClassLoader() == null) {
                return true;
            }
        } else {
            try {
                securityManager.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
                return true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection mergePermissions() {
        Enumeration<Permission> enumeration;
        PermissionCollection permissionCollection;
        if (this.staticPermissions) {
            return this.permissions;
        }
        PermissionCollection permissionCollection2 = AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

            @Override
            public PermissionCollection run() {
                Policy policy = Policy.getPolicyNoCheck();
                return policy.getPermissions(ProtectionDomain.this);
            }
        });
        Permissions permissions = new Permissions();
        int n = 32;
        int n2 = 8;
        ArrayList<Permission> arrayList = new ArrayList<Permission>(n2);
        ArrayList<Permission> arrayList2 = new ArrayList<Permission>(n);
        if (this.permissions != null) {
            permissionCollection = this.permissions;
            synchronized (permissionCollection) {
                enumeration = this.permissions.elements();
                while (enumeration.hasMoreElements()) {
                    arrayList.add(enumeration.nextElement());
                }
            }
        }
        if (permissionCollection2 != null) {
            permissionCollection = permissionCollection2;
            synchronized (permissionCollection) {
                enumeration = permissionCollection2.elements();
                while (enumeration.hasMoreElements()) {
                    arrayList2.add(enumeration.nextElement());
                    ++n2;
                }
            }
        }
        if (permissionCollection2 != null && this.permissions != null) {
            permissionCollection = this.permissions;
            synchronized (permissionCollection) {
                enumeration = this.permissions.elements();
                block11: while (enumeration.hasMoreElements()) {
                    Permission permission = enumeration.nextElement();
                    Class<?> clazz = permission.getClass();
                    String string = permission.getActions();
                    String string2 = permission.getName();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        Permission permission2 = (Permission)arrayList2.get(i);
                        if (!clazz.isInstance(permission2) || !string2.equals(permission2.getName()) || !string.equals(permission2.getActions())) continue;
                        arrayList2.remove(i);
                        continue block11;
                    }
                }
            }
        }
        if (permissionCollection2 != null) {
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                permissions.add((Permission)arrayList2.get(i));
            }
        }
        if (this.permissions != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                permissions.add((Permission)arrayList.get(i));
            }
        }
        return permissions;
    }

    static {
        SharedSecrets.setJavaSecurityAccess(new JavaSecurityAccessImpl());
        debug = Debug.getInstance("domain");
        SharedSecrets.setJavaSecurityProtectionDomainAccess(new JavaSecurityProtectionDomainAccess(){

            @Override
            public JavaSecurityProtectionDomainAccess.ProtectionDomainCache getProtectionDomainCache() {
                return new PDCache();
            }
        });
    }

    private static class WeakProtectionDomainKey
    extends WeakReference<Key> {
        private final int hash;
        private static final Key NULL_KEY = new Key();

        WeakProtectionDomainKey(ProtectionDomain protectionDomain, ReferenceQueue<Key> referenceQueue) {
            this(protectionDomain == null ? NULL_KEY : protectionDomain.key, referenceQueue);
        }

        WeakProtectionDomainKey(ProtectionDomain protectionDomain) {
            this(protectionDomain == null ? NULL_KEY : protectionDomain.key);
        }

        private WeakProtectionDomainKey(Key key, ReferenceQueue<Key> referenceQueue) {
            super(key, referenceQueue);
            this.hash = key.hashCode();
        }

        private WeakProtectionDomainKey(Key key) {
            super(key);
            this.hash = key.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof WeakProtectionDomainKey) {
                Object t = this.get();
                return t != null && t == ((WeakProtectionDomainKey)object).get();
            }
            return false;
        }
    }

    private static class PDCache
    implements JavaSecurityProtectionDomainAccess.ProtectionDomainCache {
        private final ConcurrentHashMap<WeakProtectionDomainKey, SoftReference<PermissionCollection>> pdMap = new ConcurrentHashMap();
        private final ReferenceQueue<Key> queue = new ReferenceQueue();

        private PDCache() {
        }

        @Override
        public void put(ProtectionDomain protectionDomain, PermissionCollection permissionCollection) {
            PDCache.processQueue(this.queue, this.pdMap);
            WeakProtectionDomainKey weakProtectionDomainKey = new WeakProtectionDomainKey(protectionDomain, this.queue);
            this.pdMap.put(weakProtectionDomainKey, new SoftReference<PermissionCollection>(permissionCollection));
        }

        @Override
        public PermissionCollection get(ProtectionDomain protectionDomain) {
            PDCache.processQueue(this.queue, this.pdMap);
            WeakProtectionDomainKey weakProtectionDomainKey = new WeakProtectionDomainKey(protectionDomain);
            SoftReference<PermissionCollection> softReference = this.pdMap.get(weakProtectionDomainKey);
            return softReference == null ? null : softReference.get();
        }

        private static void processQueue(ReferenceQueue<Key> referenceQueue, ConcurrentHashMap<? extends WeakReference<Key>, ?> concurrentHashMap) {
            Reference<Key> reference;
            while ((reference = referenceQueue.poll()) != null) {
                concurrentHashMap.remove(reference);
            }
        }
    }

    static final class Key {
        Key() {
        }
    }

    private static class JavaSecurityAccessImpl
    implements JavaSecurityAccess {
        private JavaSecurityAccessImpl() {
        }

        @Override
        public <T> T doIntersectionPrivilege(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext, AccessControlContext accessControlContext2) {
            if (privilegedAction == null) {
                throw new NullPointerException();
            }
            return AccessController.doPrivileged(privilegedAction, JavaSecurityAccessImpl.getCombinedACC(accessControlContext2, accessControlContext));
        }

        @Override
        public <T> T doIntersectionPrivilege(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext) {
            return this.doIntersectionPrivilege(privilegedAction, AccessController.getContext(), accessControlContext);
        }

        private static AccessControlContext getCombinedACC(AccessControlContext accessControlContext, AccessControlContext accessControlContext2) {
            AccessControlContext accessControlContext3 = new AccessControlContext(accessControlContext, accessControlContext2.getCombiner(), true);
            return new AccessControlContext(accessControlContext2.getContext(), accessControlContext3).optimize();
        }
    }
}

