/*
 * Decompiled with CFR 0.152.
 */
package org.gga.graph.impl;

import com.intellij.util.containers.EmptyIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.gga.graph.Edge;
import org.gga.graph.EdgeIterator;
import org.gga.graph.Graph;

public class FilteredGraph
implements Graph {
    private final boolean[] vertices;
    private final boolean[] edges;
    private final Graph g;

    public FilteredGraph(Graph g, GraphFilter filter) {
        this.g = g;
        this.edges = new boolean[g.E()];
        this.vertices = new boolean[g.V()];
        for (int v = 0; v < g.V(); ++v) {
            this.vertices[v] = filter.acceptVertex(v);
            Iterator<Edge> i = g.getEdges(v);
            while (i.hasNext()) {
                Edge e = i.next();
                this.edges[e.idx()] = filter.acceptEdge(e);
            }
        }
    }

    public FilteredGraph(Graph g, boolean[] vertices, boolean[] edges) {
        this.g = g;
        this.vertices = vertices;
        this.edges = edges;
    }

    @Override
    public int V() {
        return this.g.V();
    }

    @Override
    public int E() {
        return this.g.E();
    }

    @Override
    public boolean isDirected() {
        return this.g.isDirected();
    }

    @Override
    public Edge edge(int v, int w) {
        if (!this.vertices[v] || !this.vertices[w]) {
            return null;
        }
        Edge edge = this.g.edge(v, w);
        return edge != null && this.edges[edge.idx()] ? edge : null;
    }

    @Override
    public Edge insert(int v, int w) {
        throw new UnsupportedOperationException("Method insert not implemented in " + this.getClass());
    }

    @Override
    public void remove(Edge e) {
        throw new UnsupportedOperationException("Method remove not implemented in " + this.getClass());
    }

    @Override
    public EdgeIterator getEdgeIterator(int v) {
        throw new UnsupportedOperationException("Method getEdgeIterator not implemented in " + this.getClass());
    }

    @Override
    public Iterator<Edge> getEdges(int v) {
        if (!this.vertices[v]) {
            return EmptyIterator.getInstance();
        }
        ArrayList<Edge> l = new ArrayList<Edge>();
        Iterator<Edge> i = this.g.getEdges(v);
        while (i.hasNext()) {
            Edge edge = i.next();
            if (!this.edges[edge.idx()] || !this.vertices[edge.w()]) continue;
            l.add(edge);
        }
        return l.iterator();
    }

    public static interface GraphFilter {
        public boolean acceptVertex(int var1);

        public boolean acceptEdge(Edge var1);
    }
}

