/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.Microcomponent;
import com.intellij.dsm.ui.PaintRowHeaderVisitor;
import com.intellij.dsm.ui.RowHeaderMouseHandler;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class RowHeaderView<N>
extends JComponent
implements DataProvider {
    private final Set<Microcomponent> myMicrocomponents = new HashSet<Microcomponent>();
    private final DsmTableImpl<N> myDsmTable;
    private final RowHeaderMouseHandler<N> myMouseHandler;

    public RowHeaderView(DsmTableImpl<N> dsmTable) {
        this.myDsmTable = dsmTable;
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.myMouseHandler = new RowHeaderMouseHandler<N>(dsmTable, this);
        this.setToolTipText("");
    }

    @Override
    public Dimension getPreferredSize() {
        this.myDsmTable.updateCache();
        return new Dimension(this.myDsmTable.myCache.maxRowHeaderWidth + 1, this.myDsmTable.myCache.boxHeight);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        this.myDsmTable.updateCache();
        this.myDsmTable.acceptNodes(new PaintRowHeaderVisitor<N>(this.myDsmTable, g));
        for (Microcomponent microcomponent : this.myMicrocomponents) {
            microcomponent.paint(g);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.myDsmTable.requestFocus();
        }
        this.myMouseHandler.processMouseEvent(e);
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.myMouseHandler.processMouseMotionEvent(e);
    }

    void showRowHint(DsmTreeStructure.TreeNode<N> node) {
        this.myMicrocomponents.clear();
        if (this.myDsmTable.isExpanded(node)) {
            this.myMicrocomponents.add(new RowHint(node));
        }
    }

    @Nullable
    DsmTreeStructure.TreeNode<N> locateRow(Point point) {
        DsmTreeStructure.TreeNode node = null;
        int y = point.y;
        if (y < 0) {
            return null;
        }
        int rowNumber = y / this.myDsmTable.myBoxSize;
        if (rowNumber < this.myDsmTable.myCache.myRows.size()) {
            Rectangle r;
            for (node = this.myDsmTable.myCache.myRows.get(rowNumber); !(node == null || (r = this.myDsmTable.myCache.rowHeaderBounds.get(node)) != null && r.contains(point)); node = node.getParent()) {
            }
        }
        return node;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        this.myDsmTable.updateCache();
        DsmTreeStructure.TreeNode<N> node = this.locateRow(event.getPoint());
        if (node == null) {
            return null;
        }
        return StringUtil.escapeXml((String)node.getFullName());
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return this.myDsmTable.getData(dataId);
    }

    private class RowHint
    implements Microcomponent {
        private final DsmTreeStructure.TreeNode<N> myNode;

        public RowHint(DsmTreeStructure.TreeNode<N> node) {
            this.myNode = node;
        }

        @Override
        public void paint(Graphics2D g) {
            RowHeaderView.this.myDsmTable.updateCache();
            if (!((RowHeaderView)RowHeaderView.this).myDsmTable.myCache.overflowRows.contains(this.myNode)) {
                return;
            }
            Rectangle r = new Rectangle(((RowHeaderView)RowHeaderView.this).myDsmTable.myCache.rowHeaderBounds.get(this.myNode));
            Point textStart = ((RowHeaderView)RowHeaderView.this).myDsmTable.myCache.rowTextStart.get(this.myNode);
            Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(this.myNode.getShortName(), g);
            r.height = (int)((double)textStart.y + stringBounds.getWidth() + 2.0 + (double)r.width) - r.y;
            g.setPaint(RowHeaderView.this.myDsmTable.getHeaderBg(this.myNode));
            g.fillRect(r.x, textStart.y, r.width, r.height - textStart.y + r.y);
            g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
            g.drawRect(r.x, r.y, r.width, r.height);
            AffineTransform oldTransform = g.getTransform();
            g.translate(textStart.x, textStart.y);
            g.rotate(1.5707963267948966);
            PaintRowHeaderVisitor.paintRowIcon(this.myNode, 0, -r.width, r.width, RowHeaderView.this.myDsmTable, g);
            UISettings.setupAntialiasing((Graphics)g);
            g.setPaint(RowHeaderView.this.myDsmTable.getHeaderFg(this.myNode));
            g.drawString(this.myNode.getShortName(), r.width, -g.getFontMetrics().getDescent());
            g.setTransform(oldTransform);
        }
    }
}

