/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.gga.graph.maps.DataGraph;

public class ModuleGroupSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    private static final String[] EMPTY_ARR = new String[0];

    @Override
    public List<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, BooleanFunction<ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        Object[] currentPath = parentData instanceof MyNodeData ? ((MyNodeData)parentData).myGroups : EMPTY_ARR;
        HashSet<Object> subGroupsSet = new HashSet<Object>();
        boolean modulesInsideFound = false;
        boolean classedOutOfModulesFound = false;
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode2 = dataGraph.getNode(i);
            if (!memberFunction.fun((Object)classNode2)) continue;
            Module module = classNode2.module;
            if (module == null && currentPath.length == 0) {
                classedOutOfModulesFound = true;
                continue;
            }
            Object[] p = ModuleManager.getInstance((Project)module.getProject()).getModuleGroupPath(module);
            if (p == null) {
                p = EMPTY_ARR;
            }
            if (Comparing.equal((Object[])currentPath, (Object[])p)) {
                modulesInsideFound = true;
                continue;
            }
            if (!ArrayUtil.startsWith((Object[])p, (Object[])currentPath)) continue;
            subGroupsSet.add(p[currentPath.length]);
        }
        ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> result = new ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>>();
        Object[] groups = ArrayUtil.toStringArray(subGroupsSet);
        Arrays.sort(groups);
        for (Object group : groups) {
            String[] subPath = (String[])ArrayUtil.append((Object[])currentPath, (Object)group);
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(classNode -> {
                Module module = classNode.module;
                Object[] p = ModuleManager.getInstance((Project)module.getProject()).getModuleGroupPath(module);
                if (p == null) {
                    p = EMPTY_ARR;
                }
                return ArrayUtil.startsWith((Object[])p, (Object[])subPath);
            }, (Object)new MyNodeData((String)group, StringUtil.join((String[])subPath, (String)"."), AllIcons.Nodes.ModuleGroup, subPath)));
        }
        if (modulesInsideFound) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(arg_0 -> ModuleGroupSplitter.lambda$split$1((String[])currentPath, arg_0), null));
        }
        if (classedOutOfModulesFound) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(classNode -> {
                Module module = classNode.module;
                return module == null;
            }, null));
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$split$1(String[] currentPath, ClassNode classNode) {
        Module module = classNode.module;
        Object[] p = ModuleManager.getInstance((Project)module.getProject()).getModuleGroupPath(module);
        if (p == null) {
            p = EMPTY_ARR;
        }
        return Comparing.equal((Object[])p, (Object[])currentPath);
    }

    private static class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        private final String[] myGroups;

        public MyNodeData(String shortName, String fullName, Icon icon, String[] groups) {
            super(shortName, fullName, icon);
            this.myGroups = groups;
        }
    }
}

