/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.And;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.gga.graph.maps.DataGraph;

class FlattenPackagesSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    FlattenPackagesSplitter() {
    }

    @Override
    public List<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, BooleanFunction<ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> result = new ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>>();
        if (parentData instanceof MyNodeData) {
            result.add(new Pair(memberFunction, null));
            return result;
        }
        HashSet<String> packageNamesSet = new HashSet<String>();
        HashSet<ClassNode> rootClasses = new HashSet<ClassNode>();
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode2 = dataGraph.getNode(i);
            if (!memberFunction.fun((Object)classNode2)) continue;
            String packageName = classNode2.getPackageName();
            if (packageName.length() == 0) {
                rootClasses.add(classNode2);
                continue;
            }
            packageNamesSet.add(packageName);
        }
        Object[] packageNames = ArrayUtil.toStringArray(packageNamesSet);
        Arrays.sort(packageNames);
        for (Object packageName : packageNames) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(new And<ClassNode>(memberFunction, arg_0 -> FlattenPackagesSplitter.lambda$split$0((String)packageName, arg_0)), (Object)new MyNodeData((String)packageName)));
        }
        if (!rootClasses.isEmpty()) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(classNode -> rootClasses.contains(classNode), null));
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$split$0(String packageName, ClassNode classNode) {
        return classNode.getPackageName().equals(packageName);
    }

    private static class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        public MyNodeData(String packageName) {
            super(packageName, packageName, AllIcons.Nodes.Package);
        }
    }
}

