/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.DsmPsiNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassNode
implements Comparable<ClassNode>,
DsmPsiNode {
    @NotNull
    public final String className;
    @Nullable
    public final Module module;
    private String myPackageName;

    public ClassNode(String className, Module module) {
        this.className = className;
        this.module = module;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassNode classNode = (ClassNode)o;
        if (!this.className.equals(classNode.className)) {
            return false;
        }
        return !(this.module != null ? !this.module.equals(classNode.module) : classNode.module != null);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ClassNode other) {
        if (this.module == null) {
            return other.module == null ? this.className.compareTo(other.className) : -1;
        }
        if (other.module == null) {
            return 1;
        }
        int result = this.module.getName().compareTo(other.module.getName());
        if (result == 0) {
            result = this.className.compareTo(other.className);
        }
        return result;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        if (this.module == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.module.getProject());
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(this.className, this.module.getModuleScope());
        if (psiClass == null) {
            return null;
        }
        return psiClass.getContainingFile();
    }

    @Override
    @Nullable
    public PsiElement getElement() {
        if (this.module == null) {
            return null;
        }
        Project project = this.module.getProject();
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)project).findClass(this.className, this.module.getModuleScope());
    }

    public String getPackageName() {
        if (this.myPackageName != null) {
            return this.myPackageName;
        }
        int dotIndex = this.className.lastIndexOf(".");
        this.myPackageName = dotIndex >= 0 ? this.className.substring(0, dotIndex) : "<default>";
        return this.myPackageName;
    }

    public String getModuleName() {
        return this.module.getName();
    }

    public String getShortClassName() {
        int dotIndex = this.className.lastIndexOf(".");
        return dotIndex >= 0 ? this.className.substring(dotIndex + 1) : this.className;
    }
}

