/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.dsm.actions.DsmUIUtil;
import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.ClassesDsmModelBuilder;
import com.intellij.dsm.settings.DsmViewSettings;
import com.intellij.dsm.settings.DsmViewSettingsStorage;
import com.intellij.dsm.ui.DsmView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import javax.swing.SwingUtilities;

class DsmAnalysisHandler {
    private final Project myProject;
    private final AnalysisScope myScope;

    public DsmAnalysisHandler(Project project, AnalysisScope scope) {
        this.myProject = project;
        this.myScope = scope;
    }

    public void execute(ProgressIndicator indicator) {
        DsmViewSettings settings = DsmViewSettingsStorage.createSettingsCopy(this.myProject);
        DsmModel<ClassNode> model = new ClassesDsmModelBuilder(this.myProject, this.myScope, indicator).buildDsmModel(settings);
        if (model == null || model.getSize() == 0) {
            return;
        }
        DsmView<ClassNode> view = new DsmView<ClassNode>(model, settings);
        SwingUtilities.invokeLater(() -> {
            if (!this.myProject.isDisposed()) {
                DsmUIUtil.showView(this.myProject, view, this.myScope.getShortenName());
            }
        });
    }
}

