/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitMergeClient
extends BaseSvnClient
implements MergeClient {
    private static final List<SVNRevisionRange> ALL_REVISIONS_RANGE = Collections.singletonList(new SVNRevisionRange(SVNRevision.create((long)1L), SVNRevision.HEAD));

    @Override
    public void merge(@NotNull SvnTarget source, @NotNull File destination, boolean dryRun, boolean reintegrate, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        this.assertUrl(source);
        SVNDiffClient client = this.createClient(diffOptions, handler);
        try {
            if (reintegrate) {
                client.doMergeReIntegrate(source.getURL(), source.getPegRevision(), destination, dryRun);
            } else {
                client.doMerge(source.getURL(), source.getPegRevision(), ALL_REVISIONS_RANGE, destination, SVNDepth.UNKNOWN, true, false, dryRun, false);
            }
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Override
    public void merge(@NotNull SvnTarget source, @NotNull SVNRevisionRange range, @NotNull File destination, @Nullable Depth depth, boolean dryRun, boolean recordOnly, boolean force, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        this.assertUrl(source);
        try {
            this.createClient(diffOptions, handler).doMerge(source.getURL(), source.getPegRevision(), Collections.singletonList(range), destination, SvnKitMergeClient.toDepth(depth), true, force, dryRun, recordOnly);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Override
    public void merge(@NotNull SvnTarget source1, @NotNull SvnTarget source2, @NotNull File destination, @Nullable Depth depth, boolean useAncestry, boolean dryRun, boolean recordOnly, boolean force, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source1", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (source2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source2", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        this.assertUrl(source1);
        this.assertUrl(source2);
        try {
            this.createClient(diffOptions, handler).doMerge(source1.getURL(), source1.getPegRevision(), source2.getURL(), source2.getPegRevision(), destination, SvnKitMergeClient.toDepth(depth), useAncestry, force, dryRun, recordOnly);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @NotNull
    private SVNDiffClient createClient(@Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) {
        SVNDiffClient client = this.myVcs.getSvnKitManager().createDiffClient();
        client.setMergeOptions(SvnKitMergeClient.toDiffOptions(diffOptions));
        client.setEventHandler(SvnKitMergeClient.toEventHandler(handler));
        SVNDiffClient sVNDiffClient = client;
        if (sVNDiffClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "createClient"));
        }
        return sVNDiffClient;
    }
}

