/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.SeparatePiecesRunner;
import com.intellij.util.continuation.TaskDescriptor;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.integrate.CheckRepositorySupportsMergeInfoTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MergeInitChecksTask;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.tmatesoft.svn.core.SVNException;

public class QuickMerge {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final QuickMergeInteraction myInteraction;
    @NotNull
    private final SeparatePiecesRunner myRunner;

    public QuickMerge(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/QuickMerge", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/QuickMerge", "<init>"));
        }
        this.myMergeContext = mergeContext;
        this.myInteraction = interaction;
        this.myRunner = this.createRunner();
    }

    @NotNull
    public MergeContext getMergeContext() {
        MergeContext mergeContext = this.myMergeContext;
        if (mergeContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMerge", "getMergeContext"));
        }
        return mergeContext;
    }

    @NotNull
    public QuickMergeInteraction getInteraction() {
        QuickMergeInteraction quickMergeInteraction = this.myInteraction;
        if (quickMergeInteraction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMerge", "getInteraction"));
        }
        return quickMergeInteraction;
    }

    @NotNull
    public SeparatePiecesRunner getRunner() {
        SeparatePiecesRunner separatePiecesRunner = this.myRunner;
        if (separatePiecesRunner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMerge", "getRunner"));
        }
        return separatePiecesRunner;
    }

    public void execute() {
        this.runMergeTasks(null);
    }

    public void execute(@NotNull TaskDescriptor finalTask) {
        if (finalTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalTask", "org/jetbrains/idea/svn/integrate/QuickMerge", "execute"));
        }
        this.runMergeTasks(finalTask);
    }

    private void runMergeTasks(@Nullable TaskDescriptor finalTask) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Object[] tasks = new TaskDescriptor[]{new MergeInitChecksTask(this), new CheckRepositorySupportsMergeInfoTask(this), finalTask};
        this.myRunner.next(ContainerUtil.mapNotNull((Object[])tasks, (Function)Functions.identity()));
        this.myRunner.ping();
    }

    @NotNull
    private SeparatePiecesRunner createRunner() {
        SeparatePiecesRunner result = new SeparatePiecesRunner(this.myMergeContext.getProject(), true);
        result.addExceptionHandler(VcsException.class, e -> this.myInteraction.showErrors(this.myMergeContext.getTitle(), Collections.singletonList(e)));
        result.addExceptionHandler(SVNException.class, e -> this.myInteraction.showErrors(this.myMergeContext.getTitle(), Collections.singletonList(new VcsException((Throwable)e))));
        result.addExceptionHandler(RuntimeException.class, e -> this.myInteraction.showErrors((String)ObjectUtils.notNull((Object)e.getMessage(), (Object)e.getClass().getName()), Collections.singletonList(new VcsException((Throwable)e))));
        SeparatePiecesRunner separatePiecesRunner = result;
        if (separatePiecesRunner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMerge", "createRunner"));
        }
        return separatePiecesRunner;
    }
}

