/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class MergeCalculatorTask
extends BaseMergeTask {
    @NotNull
    private final SvnBranchPointsCalculator.WrapperInvertor myCopyPoint;
    @NotNull
    private final MergeChecker myMergeChecker;

    public MergeCalculatorTask(@NotNull QuickMerge mergeProcess, @NotNull SvnBranchPointsCalculator.WrapperInvertor copyPoint) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "<init>"));
        }
        if (copyPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyPoint", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "<init>"));
        }
        super(mergeProcess, "Calculating not merged revisions", Where.POOLED);
        this.myCopyPoint = copyPoint;
        this.myMergeChecker = new OneShotMergeInfoHelper(this.myMergeContext);
    }

    @Override
    public void run() throws VcsException {
        this.myMergeChecker.prepare();
        List<Pair<SvnChangeList, LogHierarchyNode>> afterCopyPointChangeLists = this.getChangeListsAfter(this.myCopyPoint.getTrue().getTargetRevision());
        List<CommittedChangeList> notMergedChangeLists = this.getNotMergedChangeLists(afterCopyPointChangeLists);
        if (!notMergedChangeLists.isEmpty()) {
            this.next(new ShowRevisionSelector(this.myMergeProcess, notMergedChangeLists, this.myMergeChecker));
        } else {
            this.end("Everything is up-to-date", false);
        }
    }

    @NotNull
    private List<Pair<SvnChangeList, LogHierarchyNode>> getChangeListsAfter(long revision) {
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.CHANGE_AFTER = Long.toString(revision);
        settings.USE_CHANGE_AFTER_FILTER = true;
        ArrayList result = ContainerUtil.newArrayList();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            ((SvnCommittedChangesProvider)this.myMergeContext.getVcs().getCommittedChangesProvider()).getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(this.myMergeContext.getSourceUrl()), 0, (PairConsumer<SvnChangeList, LogHierarchyNode>)((PairConsumer)(changeList, tree) -> {
                indicator.checkCanceled();
                if (revision < changeList.getNumber()) {
                    result.add(Pair.create((Object)changeList, (Object)tree));
                }
            }));
        }
        catch (VcsException e) {
            this.end("Checking revisions for merge fault", e);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getChangeListsAfter"));
        }
        return arrayList;
    }

    @NotNull
    private List<CommittedChangeList> getNotMergedChangeLists(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        ProgressManager.getInstance().getProgressIndicator().setText("Checking merge information...");
        String repositoryRelativeWorkingCopyRoot = SvnUtil.ensureStartSlash(SVNPathUtil.getRelativePath((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)this.myMergeContext.getWcInfo().getRootUrl()));
        String repositoryRelativeSourceBranch = SvnUtil.ensureStartSlash(SVNPathUtil.getRelativePath((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)this.myMergeContext.getSourceUrl()));
        List<CommittedChangeList> list = this.getNotMergedChangeLists(changeLists, repositoryRelativeWorkingCopyRoot, repositoryRelativeSourceBranch);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        return list;
    }

    @NotNull
    private List<CommittedChangeList> getNotMergedChangeLists(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists, @NotNull String workingCopyRoot, @NotNull String sourceBranch) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        if (workingCopyRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingCopyRoot", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (Pair<SvnChangeList, LogHierarchyNode> pair : changeLists) {
            SvnChangeList changeList = (SvnChangeList)pair.getFirst();
            ProgressManager.getInstance().getProgressIndicator().setText2("Processing revision " + changeList.getNumber());
            if (!SvnMergeInfoCache.MergeCheckResult.NOT_MERGED.equals((Object)this.myMergeChecker.checkList(changeList)) || MergeCalculatorTask.checkListForPaths(workingCopyRoot, sourceBranch, (LogHierarchyNode)pair.getSecond())) continue;
            result.add(changeList);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        return arrayList;
    }

    static boolean checkListForPaths(@NotNull String workingCopyRoot, @NotNull String sourceBranch, @NotNull LogHierarchyNode node) {
        if (workingCopyRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingCopyRoot", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkListForPaths"));
        }
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkListForPaths"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkListForPaths"));
        }
        boolean isLocalChange = ContainerUtil.or(node.getChildren(), child -> {
            if (workingCopyRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingCopyRoot", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "lambda$checkListForPaths$1"));
            }
            if (sourceBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "lambda$checkListForPaths$1"));
            }
            return MergeCalculatorTask.checkForSubtree(child, workingCopyRoot, sourceBranch);
        });
        return isLocalChange || MergeCalculatorTask.checkForEntry(node.getMe(), workingCopyRoot, sourceBranch);
    }

    private static boolean checkForSubtree(@NotNull LogHierarchyNode tree, @NotNull String relativeBranch, @NotNull String localURL) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForSubtree"));
        }
        if (relativeBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeBranch", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForSubtree"));
        }
        if (localURL == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localURL", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForSubtree"));
        }
        LinkedList<LogHierarchyNode> queue = new LinkedList<LogHierarchyNode>();
        queue.addLast(tree);
        while (!queue.isEmpty()) {
            LogHierarchyNode element = (LogHierarchyNode)queue.removeFirst();
            ProgressManager.checkCanceled();
            if (MergeCalculatorTask.checkForEntry(element.getMe(), localURL, relativeBranch)) {
                return true;
            }
            queue.addAll(element.getChildren());
        }
        return false;
    }

    private static boolean checkForEntry(@NotNull LogEntry entry, @NotNull String localURL, @NotNull String relativeBranch) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForEntry"));
        }
        if (localURL == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localURL", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForEntry"));
        }
        if (relativeBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeBranch", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForEntry"));
        }
        boolean atLeastOneUnderBranch = false;
        for (LogEntryPath path : entry.getChangedPaths().values()) {
            if (SVNPathUtil.isAncestor((String)localURL, (String)path.getPath())) {
                return true;
            }
            if (atLeastOneUnderBranch || !SVNPathUtil.isAncestor((String)relativeBranch, (String)path.getPath())) continue;
            atLeastOneUnderBranch = true;
        }
        return !atLeastOneUnderBranch;
    }

    private static class ShowRevisionSelector
    extends BaseMergeTask {
        @NotNull
        private final List<CommittedChangeList> myChangeLists;
        @NotNull
        private final MergeChecker myMergeChecker;

        private ShowRevisionSelector(@NotNull QuickMerge mergeProcess, @NotNull List<CommittedChangeList> changeLists, @NotNull MergeChecker mergeChecker) {
            if (mergeProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask$ShowRevisionSelector", "<init>"));
            }
            if (changeLists == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask$ShowRevisionSelector", "<init>"));
            }
            if (mergeChecker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeChecker", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask$ShowRevisionSelector", "<init>"));
            }
            super(mergeProcess, "show revisions to merge", Where.AWT);
            this.myChangeLists = changeLists;
            this.myMergeChecker = mergeChecker;
        }

        @Override
        public void run() {
            QuickMergeInteraction.SelectMergeItemsResult result = this.myInteraction.selectMergeItems(this.myChangeLists, this.myMergeContext.getTitle(), this.myMergeChecker);
            switch (result.getResultCode()) {
                case cancel: {
                    this.end();
                    break;
                }
                case all: {
                    this.next(this.getMergeAllTasks(true));
                    break;
                }
                default: {
                    List<CommittedChangeList> lists = result.getSelectedLists();
                    if (lists.isEmpty()) break;
                    this.runChangeListsMerge(lists, this.myMergeContext.getTitle());
                }
            }
        }
    }
}

