/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.util.Consumer;
import com.intellij.util.continuation.Where;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.LoadRecentBranchRevisions;
import org.jetbrains.idea.svn.integrate.LookForBranchOriginTask;
import org.jetbrains.idea.svn.integrate.MergeCalculatorTask;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.ShowRecentInDialogTask;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;

public class MergeAllOrSelectedChooserTask
extends BaseMergeTask {
    public MergeAllOrSelectedChooserTask(@NotNull QuickMerge mergeProcess) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/MergeAllOrSelectedChooserTask", "<init>"));
        }
        super(mergeProcess, "merge source selector", Where.AWT);
    }

    @Override
    public void run() {
        switch (this.myInteraction.selectMergeVariant()) {
            case all: {
                this.next(this.getMergeAllTasks(true));
                break;
            }
            case showLatest: {
                LoadRecentBranchRevisions loader = new LoadRecentBranchRevisions(this.myMergeProcess, -1L);
                ShowRecentInDialogTask dialog = new ShowRecentInDialogTask(this.myMergeProcess, loader);
                this.next(loader, dialog);
                break;
            }
            case select: {
                this.next(new LookForBranchOriginTask(this.myMergeProcess, false, (Consumer<SvnBranchPointsCalculator.WrapperInvertor>)((Consumer)copyPoint -> this.next(new MergeCalculatorTask(this.myMergeProcess, (SvnBranchPointsCalculator.WrapperInvertor)copyPoint)))));
            }
        }
    }
}

