/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class WCInfoWithBranches
extends WCInfo {
    @NotNull
    private final List<Branch> myBranches;
    @NotNull
    private final VirtualFile myRoot;
    private final Branch myCurrentBranch;

    public WCInfoWithBranches(@NotNull WCInfo info, @NotNull List<Branch> branches, @NotNull VirtualFile root, Branch currentBranch) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches", "<init>"));
        }
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches", "<init>"));
        }
        super(info.getRootInfo(), info.isIsWcRoot(), info.getStickyDepth());
        this.myBranches = branches;
        this.myRoot = root;
        this.myCurrentBranch = currentBranch;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    @NotNull
    public VirtualFile getVcsRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches", "getVcsRoot"));
        }
        return virtualFile;
    }

    @NotNull
    public List<Branch> getBranches() {
        List<Branch> list = this.myBranches;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches", "getBranches"));
        }
        return list;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches", "getRoot"));
        }
        return virtualFile;
    }

    public Branch getCurrentBranch() {
        return this.myCurrentBranch;
    }

    public static class Branch {
        @NotNull
        private final String myName;
        @NotNull
        private final String myUrl;

        public Branch(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches$Branch", "<init>"));
            }
            this.myName = SVNPathUtil.tail((String)url);
            this.myUrl = url;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches$Branch", "getName"));
            }
            return string;
        }

        @NotNull
        public String getUrl() {
            String string = this.myUrl;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches$Branch", "getUrl"));
            }
            return string;
        }

        public String toString() {
            return this.myName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Branch branch = (Branch)o;
            return this.myUrl.equals(branch.myUrl);
        }

        public int hashCode() {
            return this.myUrl.hashCode();
        }
    }
}

