/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.delete;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.delete.DeleteClient;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnKitDeleteClient
extends BaseSvnClient
implements DeleteClient {
    @Override
    public void delete(@NotNull File path, boolean force, boolean dryRun, @Nullable ProgressTracker handler) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/delete/SvnKitDeleteClient", "delete"));
        }
        SVNWCClient client = this.myVcs.getSvnKitManager().createWCClient();
        client.setEventHandler(SvnKitDeleteClient.toEventHandler(handler));
        try {
            client.doDelete(path, force, dryRun);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Override
    public long delete(@NotNull SVNURL url, @NotNull String message) throws VcsException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/delete/SvnKitDeleteClient", "delete"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/delete/SvnKitDeleteClient", "delete"));
        }
        try {
            SVNCommitInfo commitInfo = this.myVcs.getSvnKitManager().createCommitClient().doDelete(new SVNURL[]{url}, message);
            return commitInfo.getNewRevision();
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }
}

