/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWorkingCopyFormatHolder;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.ExclusiveBackgroundVcsAction;
import org.jetbrains.idea.svn.actions.SvnExcludingIgnoredOperation;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.checkout.CheckoutEventHandler;
import org.jetbrains.idea.svn.checkout.ExportClient;
import org.jetbrains.idea.svn.dialogs.CheckoutDialog;
import org.jetbrains.idea.svn.dialogs.UpgradeFormatDialog;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNFileFilter;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(@NotNull Project project, CheckoutProvider.Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider", "doCheckout"));
        }
        CheckoutDialog dialog = new CheckoutDialog(project, listener);
        dialog.show();
    }

    public static void doCheckout(@NotNull Project project, @NotNull File target, String url, SVNRevision revision, Depth depth, boolean ignoreExternals, @Nullable CheckoutProvider.Listener listener) {
        WorkingCopyFormat selectedFormat;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider", "doCheckout"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider", "doCheckout"));
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((selectedFormat = SvnCheckoutProvider.promptForWCopyFormat(target, project)) != WorkingCopyFormat.UNKNOWN) {
            SvnCheckoutProvider.checkout(project, target, url, revision, depth, ignoreExternals, listener, selectedFormat);
        }
    }

    @NotNull
    public static ClientFactory getFactory(@NotNull SvnVcs vcs, @NotNull WorkingCopyFormat format) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider", "getFactory"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider", "getFactory"));
        }
        ClientFactory settingsFactory = vcs.getFactoryFromSettings();
        ClientFactory otherFactory = vcs.getOtherFactory();
        List<WorkingCopyFormat> settingsFactoryFormats = settingsFactory.createCheckoutClient().getSupportedFormats();
        List otherFactoryFormats = CheckoutFormatFromUserProvider.getOtherFactoryFormats(otherFactory);
        ClientFactory clientFactory = settingsFactoryFormats.contains((Object)format) || !otherFactoryFormats.contains((Object)format) ? settingsFactory : otherFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider", "getFactory"));
        }
        return clientFactory;
    }

    public static void checkout(final Project project, final File target, final String url, final SVNRevision revision, final Depth depth, final boolean ignoreExternals, final CheckoutProvider.Listener listener, final WorkingCopyFormat selectedFormat) {
        final Ref checkoutSuccessful = new Ref();
        final Exception[] exception = new Exception[1];
        Task.Backgroundable checkoutBackgroundTask = new Task.Backgroundable(project, SvnBundle.message("message.title.check.out", new Object[0]), true, VcsConfiguration.getInstance((Project)project).getCheckoutOption()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$1", "run"));
                }
                WorkingCopyFormat format = selectedFormat == null ? WorkingCopyFormat.UNKNOWN : selectedFormat;
                SvnWorkingCopyFormatHolder.setPresetFormat(format);
                SvnVcs vcs = SvnVcs.getInstance(project);
                CheckoutEventHandler handler = new CheckoutEventHandler(vcs, false, ProgressManager.getInstance().getProgressIndicator());
                ProgressManager.progress((String)SvnBundle.message("progress.text.checking.out", target.getAbsolutePath()));
                try {
                    SvnCheckoutProvider.getFactory(vcs, format).createCheckoutClient().checkout(SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)url)), target, revision, depth, ignoreExternals, true, format, handler);
                    ProgressManager.checkCanceled();
                    checkoutSuccessful.set((Object)Boolean.TRUE);
                }
                catch (SVNCancelException sVNCancelException) {
                }
                catch (SVNException e) {
                    exception[0] = e;
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
                finally {
                    SvnWorkingCopyFormatHolder.setPresetFormat(null);
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                VirtualFile vf;
                if (exception[0] != null) {
                    Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.checkout", exception[0].getMessage()), (String)SvnBundle.message("message.title.check.out", new Object[0]));
                }
                if ((vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(target)) != null) {
                    vf.refresh(true, true, () -> ApplicationManager.getApplication().invokeLater(() -> this.notifyListener()));
                } else {
                    this.notifyListener();
                }
            }

            private void notifyListener() {
                SvnCheckoutProvider.notifyRootManagerIfUnderProject(project, target);
                if (listener != null) {
                    if (!checkoutSuccessful.isNull()) {
                        listener.directoryCheckedOut(target, SvnVcs.getKey());
                    }
                    listener.checkoutCompleted();
                }
            }
        };
        ProgressManager.getInstance().run((Task)checkoutBackgroundTask);
    }

    private static void notifyRootManagerIfUnderProject(Project project, File directory) {
        VirtualFile[] files;
        if (project.isDefault()) {
            return;
        }
        ProjectLevelVcsManagerEx plVcsManager = ProjectLevelVcsManagerEx.getInstanceEx((Project)project);
        SvnVcs vcs = (SvnVcs)plVcsManager.findVcsByName("svn");
        for (VirtualFile file : files = vcs.getSvnFileUrlMapping().getNotFilteredRoots()) {
            if (!FileUtil.isAncestor((File)new File(file.getPath()), (File)directory, (boolean)false)) continue;
            plVcsManager.fireDirectoryMappingsChanged();
            return;
        }
    }

    @NotNull
    public static WorkingCopyFormat promptForWCopyFormat(@NotNull File target, @NotNull Project project) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider", "promptForWCopyFormat"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider", "promptForWCopyFormat"));
        }
        WorkingCopyFormat workingCopyFormat = new CheckoutFormatFromUserProvider(project, target).prompt();
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider", "promptForWCopyFormat"));
        }
        return workingCopyFormat;
    }

    public static void doExport(Project project, final File target, final SVNURL url, final Depth depth, final boolean ignoreExternals, final boolean force, final String eolStyle) {
        try {
            final VcsException[] exception = new VcsException[1];
            final SvnVcs vcs = SvnVcs.getInstance(project);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    CheckoutEventHandler handler = new CheckoutEventHandler(vcs, true, progressIndicator);
                    try {
                        progressIndicator.setText(SvnBundle.message("progress.text.export", target.getAbsolutePath()));
                        SvnTarget from = SvnTarget.fromURL((SVNURL)url);
                        ExportClient client = vcs.getFactoryFromSettings().createExportClient();
                        client.export(from, target, SVNRevision.HEAD, depth, eolStyle, force, ignoreExternals, handler);
                    }
                    catch (VcsException e) {
                        exception[0] = e;
                    }
                }
            }, SvnBundle.message("message.title.export", new Object[0]), true, project);
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.export", e1.getMessage()), (String)SvnBundle.message("message.title.export", new Object[0]));
        }
    }

    public static void doImport(final Project project, final File target, final SVNURL url, final Depth depth, final boolean includeIgnored, final String message) {
        final Ref errorMessage = new Ref();
        final SvnVcs vcs = SvnVcs.getInstance(project);
        final String targetPath = FileUtil.toSystemIndependentName((String)target.getAbsolutePath());
        ExclusiveBackgroundVcsAction.run(project, new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                    @Override
                    public void run() {
                        final FileIndexFacade facade = (FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(project, FileIndexFacade.class);
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        try {
                            progressIndicator.setText(SvnBundle.message("progress.text.import", target.getAbsolutePath()));
                            final VirtualFile targetVf = SvnUtil.getVirtualFile(targetPath);
                            if (targetVf == null) {
                                errorMessage.set((Object)("Can not find file: " + targetPath));
                            } else {
                                boolean isInContent = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                                    public Boolean compute() {
                                        return facade.isInContent(targetVf);
                                    }
                                });
                                IdeaCommitHandler handler = new IdeaCommitHandler(progressIndicator);
                                boolean useFileFilter = !project.isDefault() && isInContent;
                                MyFilter commitHandler = useFileFilter ? new MyFilter(LocalFileSystem.getInstance(), new SvnExcludingIgnoredOperation.Filter(project)) : null;
                                long revision = vcs.getFactoryFromSettings().createImportClient().doImport(target, url, depth, message, includeIgnored, handler, (ISVNCommitHandler)commitHandler);
                                if (revision > 0L) {
                                    StatusBar.Info.set((String)SvnBundle.message("status.text.comitted.revision", revision), (Project)project);
                                }
                            }
                        }
                        catch (VcsException e) {
                            errorMessage.set((Object)e.getMessage());
                        }
                    }
                }, SvnBundle.message("message.title.import", new Object[0]), true, project);
            }
        });
        if (!errorMessage.isNull()) {
            Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.import", errorMessage.get()), (String)SvnBundle.message("message.title.import", new Object[0]));
        }
    }

    public String getVcsName() {
        return "_Subversion";
    }

    public static class CheckoutFormatFromUserProvider {
        private static final Logger LOG = Logger.getInstance(CheckoutFormatFromUserProvider.class);
        @NotNull
        private final Project myProject;
        @NotNull
        private final SvnVcs myVcs;
        @NotNull
        private final File myPath;
        @NotNull
        private final AtomicReference<String> error;

        public CheckoutFormatFromUserProvider(@NotNull Project project, @NotNull File path) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$CheckoutFormatFromUserProvider", "<init>"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$CheckoutFormatFromUserProvider", "<init>"));
            }
            this.myProject = project;
            this.myVcs = SvnVcs.getInstance(project);
            this.myPath = path;
            this.error = new AtomicReference();
        }

        public WorkingCopyFormat prompt() {
            assert (!ApplicationManager.getApplication().isUnitTestMode());
            WorkingCopyFormat result = this.displayUpgradeDialog();
            ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(SvnVcs.WC_CONVERTED)).run();
            return result;
        }

        @NotNull
        private WorkingCopyFormat displayUpgradeDialog() {
            final UpgradeFormatDialog dialog = new UpgradeFormatDialog(this.myProject, this.myPath, false);
            final ModalityState dialogState = ModalityState.any();
            dialog.startLoading();
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    final List formats = this.loadSupportedFormats();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String errorMessage = (String)error.get();
                            if (errorMessage != null) {
                                dialog.doCancelAction();
                                Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.load.supported.formats", errorMessage), (String)SvnBundle.message("message.title.check.out", new Object[0]));
                            } else {
                                dialog.setSupported(formats);
                                dialog.setData((WorkingCopyFormat)((Object)ContainerUtil.getFirstItem((Collection)formats, (Object)((Object)WorkingCopyFormat.UNKNOWN))));
                                dialog.stopLoading();
                            }
                        }
                    }, dialogState);
                }
            });
            WorkingCopyFormat workingCopyFormat = dialog.showAndGet() ? dialog.getUpgradeMode() : WorkingCopyFormat.UNKNOWN;
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$CheckoutFormatFromUserProvider", "displayUpgradeDialog"));
            }
            return workingCopyFormat;
        }

        @NotNull
        private List<WorkingCopyFormat> loadSupportedFormats() {
            ArrayList result = ContainerUtil.newArrayList();
            try {
                result.addAll(this.myVcs.getFactoryFromSettings().createCheckoutClient().getSupportedFormats());
                result.addAll(CheckoutFormatFromUserProvider.getOtherFactoryFormats(this.myVcs.getOtherFactory()));
            }
            catch (VcsException e) {
                this.error.set(e.getMessage());
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$CheckoutFormatFromUserProvider", "loadSupportedFormats"));
            }
            return arrayList;
        }

        @NotNull
        private static List<WorkingCopyFormat> getOtherFactoryFormats(@NotNull ClientFactory otherFactory) {
            ArrayList result;
            if (otherFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherFactory", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$CheckoutFormatFromUserProvider", "getOtherFactoryFormats"));
            }
            try {
                result = otherFactory.createCheckoutClient().getSupportedFormats();
            }
            catch (VcsException e) {
                result = ContainerUtil.newArrayList();
                LOG.info("Failed to get checkout formats from other factory", (Throwable)e);
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$CheckoutFormatFromUserProvider", "getOtherFactoryFormats"));
            }
            return arrayList;
        }
    }

    private static class MyFilter
    extends DefaultSVNCommitHandler
    implements ISVNFileFilter {
        private final LocalFileSystem myLfs;
        private final SvnExcludingIgnoredOperation.Filter myFilter;

        private MyFilter(LocalFileSystem lfs, SvnExcludingIgnoredOperation.Filter filter) {
            this.myLfs = lfs;
            this.myFilter = filter;
        }

        public boolean accept(File file) throws SVNException {
            VirtualFile vf = this.myLfs.findFileByIoFile(file);
            return vf != null && this.myFilter.accept(vf);
        }
    }
}

