/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.agent;

import com.intellij.javaee.oss.agent.AgentCallback;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.SimpleAgentBase;
import com.intellij.javaee.oss.agent.SimpleAgentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.management.JMException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;

public class JBoss7Agent
extends SimpleAgentBase {
    private static final int MAX_CONNECTION_ATTEMPTS = 3;
    private static final int CONNECTION_DELAY_MS = 1000;
    private boolean myDomain;
    private String myServerGroup;
    private ModelControllerClient myClient;
    private String myHost;
    private String[] myDomainServers;

    public void init(String host, int port, String username, String password, ParametersMap initParameters, AgentCallback callback) {
        super.init(host, port, username, password, initParameters, callback);
        this.myDomain = Boolean.parseBoolean((String)initParameters.get((Object)"is.domain"));
        this.myServerGroup = (String)initParameters.get((Object)"server.group");
        if (this.isLocalDomain()) {
            this.myHost = (String)initParameters.get((Object)"domain.host");
            this.myDomainServers = ((String)initParameters.get((Object)"server.names")).split(";");
        }
    }

    protected boolean doConnect() throws IOException, JMException, SimpleAgentException {
        if (this.myClient == null) {
            this.myClient = ModelControllerClient.Factory.create((String)this.getHost(), (int)this.getPort(), (CallbackHandler)new AuthHandler());
        }
        int connectionAttempts = 0;
        while (true) {
            ++connectionAttempts;
            try {
                return this.createValidateOperation(new RootAddressSetup()).validate() && (!this.isLocalDomain() || this.isDomainServersStarted(this.myHost, this.myDomainServers));
            }
            catch (IOException e) {
                if (this.isLocal() || !e.getMessage().contains("JBAS012144") || connectionAttempts == 3) {
                    throw e;
                }
                this.getLog().debugEx((Exception)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    throw new SimpleAgentException((Exception)e2);
                }
            }
        }
    }

    protected void doDeploy(final String deploymentName, final File source, final ParametersMap deployParameters) throws IOException, JMException, SimpleAgentException {
        try {
            final boolean nativeDeploymentMethod = Boolean.parseBoolean((String)deployParameters.get((Object)"native.deployment.method"));
            if (!new DeploymentOperation("add", deploymentName){

                @Override
                protected void setup(ModelNode request) {
                    super.setup(request);
                    ModelNode contentItem = request.get("content").get(0);
                    if (nativeDeploymentMethod) {
                        contentItem.get("input-stream-index").set(0);
                    } else {
                        contentItem.get("path").set((String)deployParameters.get((Object)"source.path"));
                        contentItem.get("archive").set(!source.isDirectory());
                    }
                    if (Boolean.parseBoolean((String)deployParameters.get((Object)"runtime.name.for.war"))) {
                        request.get("runtime-name").set(deploymentName + ".war");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected ModelNode doExecute(ModelNode request) throws IOException {
                    if (nativeDeploymentMethod) {
                        OperationBuilder builder = new OperationBuilder(request);
                        builder.addInputStream((InputStream)new FileInputStream(source));
                        org.jboss.as.controller.client.Operation operation = builder.build();
                        try {
                            ModelNode modelNode = JBoss7Agent.this.myClient.execute(operation);
                            return modelNode;
                        }
                        finally {
                            try {
                                operation.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    return super.doExecute(request);
                }
            }.executeOrFail()) {
                return;
            }
            if (this.myDomain && !new JointDeploymentOperation("add", deploymentName).executeOrFail()) {
                return;
            }
            new JointDeploymentOperation("deploy", deploymentName).executeOrFail();
        }
        catch (SimpleAgentException e) {
            this.doUndeploy(deploymentName);
            throw e;
        }
    }

    protected void doUndeploy(String deploymentName) throws IOException, JMException, SimpleAgentException {
        if (!this.isDeploymentRegistered(deploymentName)) {
            return;
        }
        if (this.isDeploymentEnabled(deploymentName)) {
            new JointDeploymentOperation("undeploy", deploymentName).execute();
        }
        if (this.myDomain) {
            new JointDeploymentOperation("remove", deploymentName).execute();
        }
        new DeploymentOperation("remove", deploymentName).execute();
    }

    protected boolean doIsDeployed(String deploymentName) throws IOException, JMException, SimpleAgentException {
        return this.isDeploymentRegistered(deploymentName) && this.isDeploymentEnabled(deploymentName);
    }

    private boolean isLocal() {
        return Boolean.parseBoolean((String)this.getInitParameters().get((Object)"is.local"));
    }

    private boolean isLocalDomain() {
        return this.isLocal() && this.myDomain;
    }

    private boolean isDeploymentRegistered(String deploymentName) throws IOException {
        return this.createValidateOperation(new DeploymentAddressSetup(deploymentName)).validate();
    }

    private boolean isDeploymentEnabled(String deploymentName) throws IOException {
        JointDeploymentOperation readEnabledOp = new JointDeploymentOperation("read-attribute", deploymentName){

            @Override
            protected void setup(ModelNode request) {
                super.setup(request);
                request.get("name").set("enabled");
            }
        };
        if (!readEnabledOp.execute()) {
            return false;
        }
        return readEnabledOp.getResult().asBoolean(false);
    }

    private boolean isDomainServersStarted(String hostName, String ... serverNames) throws IOException {
        for (String serverName : serverNames) {
            ReadServerStatusOperation readServerStatus = new ReadServerStatusOperation(new HostServerConfigAddressSetup(hostName, serverName));
            if (!readServerStatus.execute()) {
                return false;
            }
            if ("STARTED".equals(readServerStatus.getResult().get("status").asString())) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        if (this.myClient == null) {
            return;
        }
        if (this.isLocal()) {
            try {
                new Operation("shutdown", this.myDomain ? new HostAddressSetup(this.myHost) : new RootAddressSetup()).execute();
            }
            catch (IOException e) {
                this.getLog().debugEx((Exception)e);
            }
        }
        try {
            this.myClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected ValidateOperation createValidateOperation(AddressSetup addressSetup) {
        return new ValidateOperation(addressSetup);
    }

    private class AuthHandler
    implements CallbackHandler {
        private AuthHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                JBoss7Agent.this.getLog().debug("Auth: anonymous");
                ((NameCallback)callbacks[0]).setName("anonymous CLI user");
                return;
            }
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    JBoss7Agent.this.getLog().debug("Auth: realm");
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    JBoss7Agent.this.getLog().debug("Auth: realm choice");
                    continue;
                }
                if (current instanceof NameCallback) {
                    JBoss7Agent.this.getLog().debug("Auth: username");
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(JBoss7Agent.this.getUsername());
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    JBoss7Agent.this.getLog().debug("Auth: password");
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(JBoss7Agent.this.getPassword().toCharArray());
                    continue;
                }
                JBoss7Agent.this.getLog().debug("Auth: unknown callback");
            }
        }
    }

    private static class DeploymentAddressSetup
    implements AddressSetup {
        private final String myDeploymentName;

        public DeploymentAddressSetup(String deploymentName) {
            this.myDeploymentName = deploymentName;
        }

        @Override
        public void setupAddress(ModelNode address) {
            address.add("deployment", this.myDeploymentName);
        }
    }

    private class JointDeploymentAddressSetup
    extends DeploymentAddressSetup {
        private JointDeploymentAddressSetup(String deploymentName) {
            super(deploymentName);
        }

        @Override
        public void setupAddress(ModelNode address) {
            if (JBoss7Agent.this.myDomain) {
                address.add("server-group", JBoss7Agent.this.myServerGroup);
            }
            super.setupAddress(address);
        }
    }

    private static class HostAddressSetup
    implements AddressSetup {
        private final String myHostName;

        private HostAddressSetup(String hostName) {
            this.myHostName = hostName;
        }

        @Override
        public void setupAddress(ModelNode address) {
            address.add("host", this.myHostName);
        }
    }

    private static class HostServerConfigAddressSetup
    extends HostAddressSetup {
        private final String myServerName;

        private HostServerConfigAddressSetup(String hostName, String serverName) {
            super(hostName);
            this.myServerName = serverName;
        }

        @Override
        public void setupAddress(ModelNode address) {
            super.setupAddress(address);
            address.add("server-config", this.myServerName);
        }
    }

    private static class RootAddressSetup
    implements AddressSetup {
        private RootAddressSetup() {
        }

        @Override
        public void setupAddress(ModelNode address) {
            address.setEmptyList();
        }
    }

    protected static interface AddressSetup {
        public void setupAddress(ModelNode var1);
    }

    protected class ValidateOperation
    extends Operation {
        public ValidateOperation(AddressSetup addressSetup) {
            super("validate-address", addressSetup);
        }

        public boolean validate() throws IOException {
            return this.execute();
        }
    }

    private class DeploymentOperation
    extends Operation {
        public DeploymentOperation(String name, String deploymentName) {
            super(name, new DeploymentAddressSetup(deploymentName));
        }
    }

    private class JointDeploymentOperation
    extends Operation {
        public JointDeploymentOperation(String name, String deploymentName) {
            super(name, new JointDeploymentAddressSetup(deploymentName));
        }
    }

    private class ReadServerStatusOperation
    extends Operation {
        public ReadServerStatusOperation(HostServerConfigAddressSetup addressSetup) {
            super("read-resource", addressSetup);
        }

        @Override
        protected void setup(ModelNode request) {
            super.setup(request);
            request.get("include-runtime").set("true");
        }
    }

    private class Operation {
        private final String myName;
        private final AddressSetup myAddressSetup;
        private ModelNode myResult;

        public Operation(String name, AddressSetup addressSetup) {
            this.myName = name;
            this.myAddressSetup = addressSetup;
        }

        public boolean execute() throws IOException {
            try {
                return this.executeOrFail();
            }
            catch (SimpleAgentException e) {
                return false;
            }
        }

        public boolean executeOrFail() throws IOException, SimpleAgentException {
            ModelNode failureDescription;
            boolean success;
            ModelNode request = new ModelNode();
            request.get("operation").set(this.myName);
            this.setup(request);
            ModelNode response = this.doExecute(request);
            if (response == null) {
                return false;
            }
            this.myResult = response.get("result");
            ModelNode outcome = response.get("outcome");
            boolean bl = success = outcome != null && outcome.asString().equals("success");
            if (!success && (failureDescription = response.get("failure-description")) != null) {
                throw new SimpleAgentException(new Exception(failureDescription.asString()));
            }
            return success;
        }

        protected ModelNode doExecute(ModelNode request) throws IOException {
            return JBoss7Agent.this.myClient.execute(request);
        }

        protected void setup(ModelNode request) {
            ModelNode address = request.get("address");
            this.setupAddress(address);
        }

        protected final void setupAddress(ModelNode address) {
            this.myAddressSetup.setupAddress(address);
        }

        public ModelNode getResult() {
            return this.myResult;
        }
    }
}

