/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.view;

import com.intellij.batch.model.job.Identified;
import com.intellij.batch.model.job.IdentifiedContainer;
import com.intellij.batch.utils.BatchCommonUtils;
import com.intellij.batch.view.BatchJobsRecursivePanel;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import icons.BatchCoreIcons;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchStepsPanel
extends FinderRecursivePanel<Identified> {
    @NotNull
    private final BatchJobsRecursivePanel myParent;
    private final Module myModule;

    public BatchStepsPanel(@NotNull BatchJobsRecursivePanel parent, @Nullable Module module) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/batch/view/BatchStepsPanel", "<init>"));
        }
        super((FinderRecursivePanel)parent);
        this.myParent = parent;
        this.myModule = module;
    }

    @Nullable
    protected JComponent createRightComponent(Identified identified) {
        return null;
    }

    private JComponent getDocumentationComponent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/batch/view/BatchStepsPanel", "getDocumentationComponent"));
        }
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
        DocumentationComponent component = new DocumentationComponent(manager);
        manager.fetchDocInfo(element, component);
        Disposer.register((Disposable)this, (Disposable)component);
        return component;
    }

    protected JComponent createDefaultRightComponent() {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        Identified jamElement = (Identified)this.getSelectedValue();
        PsiElement element = BatchStepsPanel.getPsiElement(jamElement);
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && element != null) {
            return element;
        }
        return super.getData(dataId);
    }

    @Nullable
    private static PsiElement getPsiElement(Identified jamElement) {
        if (jamElement == null) {
            return null;
        }
        return jamElement.getXmlElement();
    }

    @NotNull
    protected String getItemText(Identified ip) {
        String value = ip.getId().getStringValue();
        String string = value == null ? "" : value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/view/BatchStepsPanel", "getItemText"));
        }
        return string;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, Identified ip, int index, boolean selected, boolean hasFocus) {
        comp.clear();
        comp.setIcon(this.getItemIcon(ip));
        String typeName = ip.getPresentation().getTypeName();
        comp.append(this.getItemText(ip));
        if (!StringUtil.isEmpty((String)typeName)) {
            comp.append(" (" + typeName + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected Icon getItemIcon(Identified ip) {
        return BatchCoreIcons.Step;
    }

    @NotNull
    protected List<Identified> getListItems() {
        List<Identified> list = BatchCommonUtils.getAllIdentified((IdentifiedContainer)this.myParent.getSelectedValue());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/view/BatchStepsPanel", "getListItems"));
        }
        return list;
    }

    protected boolean hasChildren(Identified ip) {
        return false;
    }

    public Module getModule() {
        return this.myModule;
    }
}

