/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.view;

import com.intellij.batch.model.BatchJobXmlModel;
import com.intellij.batch.model.BatchXmlDomModelManager;
import com.intellij.batch.model.job.Job;
import com.intellij.batch.utils.BatchCommonUtils;
import com.intellij.batch.view.BatchStepsPanel;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.containers.hash.HashSet;
import icons.BatchCoreIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchJobsRecursivePanel
extends FinderRecursivePanel<Job> {
    private final Module myModule;

    public BatchJobsRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, DefaultActionGroup actions) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/batch/view/BatchJobsRecursivePanel", "<init>"));
        }
        super(parent);
        this.myModule = module;
    }

    @Nullable
    protected JComponent createRightComponent(Job job) {
        if (this.hasChildren(job)) {
            return new BatchStepsPanel(this, this.getModule());
        }
        return super.createRightComponent((Object)job);
    }

    private JComponent getJobDescriptorInfoPanel(Job job) {
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
        DocumentationComponent component = new DocumentationComponent(manager);
        manager.fetchDocInfo((PsiElement)job.getXmlElement(), component);
        Disposer.register((Disposable)this, (Disposable)component);
        return component;
    }

    @NotNull
    protected String getItemText(Job job) {
        String name = job.getId().getStringValue();
        String string = name == null ? "" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/view/BatchJobsRecursivePanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(Job job) {
        return BatchCoreIcons.Batch;
    }

    @NotNull
    protected Set<Job> getListItems(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/batch/view/BatchJobsRecursivePanel", "getListItems"));
        }
        HashSet points = new HashSet();
        for (BatchJobXmlModel model : BatchXmlDomModelManager.getInstance(module.getProject()).getAllBatchJobModels(module)) {
            points.add(model.getJob());
        }
        HashSet hashSet = points;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/view/BatchJobsRecursivePanel", "getListItems"));
        }
        return hashSet;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        Job value = (Job)this.getSelectedValue();
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && value != null) {
            return value.getXmlElement();
        }
        return super.getData(dataId);
    }

    @NotNull
    protected List<Job> getListItems() {
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (this.myModule != null) {
            jobs.addAll(this.getListItems(this.myModule));
        } else {
            for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                if (!BatchCommonUtils.isBatchInstalled(module)) continue;
                jobs.addAll(this.getListItems(module));
            }
        }
        Collections.sort(jobs, (o1, o2) -> {
            String value1 = o1.getId().getStringValue();
            String value2 = o2.getId().getStringValue();
            if (value1 != null && value2 != null) {
                return value1.compareTo(value2);
            }
            return 0;
        });
        ArrayList<Job> arrayList = jobs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/view/BatchJobsRecursivePanel", "getListItems"));
        }
        return arrayList;
    }

    protected boolean hasChildren(Job job) {
        return BatchCommonUtils.getAllIdentified(job).size() > 0;
    }

    public Module getModule() {
        return this.myModule;
    }
}

