/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.providers;

import com.intellij.batch.utils.BatchCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlSchemaProvider;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchXmlSchemaProvider
extends XmlSchemaProvider {
    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/batch/providers/BatchXmlSchemaProvider", "isAvailable"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return BatchCommonUtils.isBatchInstalled(module);
    }

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/batch/providers/BatchXmlSchemaProvider", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/batch/providers/BatchXmlSchemaProvider", "getSchema"));
        }
        if (module == null) {
            return null;
        }
        String resourceName = BatchXmlSchemaProvider.getResourceName(url, baseFile);
        if (resourceName == null) {
            return null;
        }
        URL resource = BatchXmlSchemaProvider.class.getResource(resourceName);
        if (resource != null) {
            VirtualFile virtualFile = VfsUtil.findFileByURL((URL)resource);
            PsiFile psiFile = baseFile.getManager().findFile(virtualFile);
            return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        }
        return null;
    }

    @Nullable
    private static String getResourceName(String url, PsiFile baseFile) {
        XmlTag rootTag;
        if (url.startsWith("http://xmlns.jcp.org/xml/ns/javaee") && baseFile instanceof XmlFile && (rootTag = ((XmlFile)baseFile).getRootTag()) != null) {
            String localName = rootTag.getLocalName();
            if (localName.equals("batch-artifacts")) {
                return "/resources/schemas/batchXML_1_0.xsd";
            }
            if (localName.equals("job")) {
                return "/resources/schemas/jobXML_1_0.xsd";
            }
        }
        return null;
    }
}

