/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.inspections;

import com.intellij.batch.RequiredArtifactType;
import com.intellij.batch.model.BatchArtifactRefBean;
import com.intellij.batch.model.job.Job;
import com.intellij.batch.resources.BatchBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequiredArtifactTypeInspection
extends DomElementsInspection<Job> {
    public RequiredArtifactTypeInspection() {
        super(Job.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (!(element instanceof GenericAttributeValue)) {
            return;
        }
        Object value = ((GenericAttributeValue)element).getValue();
        if (value == null) {
            return;
        }
        if (value instanceof BatchArtifactRefBean) {
            List<PsiClass> foundRequiredClasses = RequiredArtifactTypeInspection.getRequiredArtifactTypeClasses(element);
            BatchArtifactRefBean artifactRef = (BatchArtifactRefBean)value;
            PsiType type = artifactRef.getType();
            RequiredArtifactTypeInspection.checkArtifactType(element, holder, foundRequiredClasses, type);
        }
    }

    @NotNull
    public static List<PsiClass> getRequiredArtifactTypeClasses(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/batch/inspections/RequiredArtifactTypeInspection", "getRequiredArtifactTypeClasses"));
        }
        RequiredArtifactType type = (RequiredArtifactType)element.getAnnotation(RequiredArtifactType.class);
        if (type == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/inspections/RequiredArtifactTypeInspection", "getRequiredArtifactTypeClasses"));
            }
            return list;
        }
        SmartList types = new SmartList();
        for (String className : type.value()) {
            PsiClass psiClass = DomJavaUtil.findClass((String)className, (DomElement)element);
            if (psiClass == null) continue;
            types.add(psiClass);
        }
        SmartList smartList = types;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/inspections/RequiredArtifactTypeInspection", "getRequiredArtifactTypeClasses"));
        }
        return smartList;
    }

    private static void checkArtifactType(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull List<PsiClass> psiClasses, @Nullable PsiType type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/batch/inspections/RequiredArtifactTypeInspection", "checkArtifactType"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/batch/inspections/RequiredArtifactTypeInspection", "checkArtifactType"));
        }
        if (psiClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClasses", "com/intellij/batch/inspections/RequiredArtifactTypeInspection", "checkArtifactType"));
        }
        if (type == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)element.getManager().getProject()).getElementFactory();
        for (PsiClass requiredClass : psiClasses) {
            PsiClassType reqType = factory.createType(requiredClass);
            if (!reqType.isAssignableFrom(type)) continue;
            return;
        }
        List names = ContainerUtil.map(psiClasses, psiClass -> psiClass.getQualifiedName());
        String classText = psiClasses.size() == 1 ? (String)names.get(0) : StringUtil.join((Collection)names, (String)",");
        String message = psiClasses.size() == 1 ? BatchBundle.message("artifact.must.be.of.type", classText) : BatchBundle.message("artifact.must.be.one.of.these.types", classText);
        holder.createProblem(element, message, new LocalQuickFix[0]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("RequiredArtifactTypeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/inspections/RequiredArtifactTypeInspection", "getShortName"));
        }
        return "RequiredArtifactTypeInspection";
    }
}

