/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.config;

import com.intellij.batch.config.BatchLibraryType;
import com.intellij.batch.resources.BatchBundle;
import com.intellij.framework.FrameworkGroup;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.LibraryBasedFrameworkSupportProvider;
import com.intellij.framework.library.LibraryBasedFrameworkType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.javaee.framework.JavaeeFrameworkGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchFrameworkType
extends LibraryBasedFrameworkType {
    protected BatchFrameworkType() {
        super("BatchApplications", BatchLibraryType.class);
    }

    @NotNull
    public String getPresentableName() {
        String string = BatchBundle.message("batch.jsr.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/config/BatchFrameworkType", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public FrameworkGroup<?> getParentGroup() {
        return JavaeeFrameworkGroup.INSTANCE;
    }

    @NotNull
    public FrameworkSupportInModuleProvider createProvider() {
        LibraryBasedFrameworkSupportProvider libraryBasedFrameworkSupportProvider = new LibraryBasedFrameworkSupportProvider((FrameworkTypeEx)this, this.getLibraryTypeClass()){

            @NotNull
            public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/batch/config/BatchFrameworkType$1", "createConfigurable"));
                }
                MyGenerateConfigurable myGenerateConfigurable = new MyGenerateConfigurable();
                if (myGenerateConfigurable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/config/BatchFrameworkType$1", "createConfigurable"));
                }
                return myGenerateConfigurable;
            }

            public List<FrameworkSupportInModuleProvider.FrameworkDependency> getDependenciesFrameworkIds() {
                return Collections.singletonList(FrameworkSupportInModuleProvider.FrameworkDependency.optional((String)"web"));
            }
        };
        if (libraryBasedFrameworkSupportProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/config/BatchFrameworkType", "createProvider"));
        }
        return libraryBasedFrameworkSupportProvider;
    }

    @Nullable
    private static String getMetaInfPath(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/batch/config/BatchFrameworkType", "getMetaInfPath"));
        }
        VirtualFile[] roots = rootModel.getSourceRoots();
        String defaultPath = null;
        for (VirtualFile file : roots) {
            String path = file.getUrl() + "/META-INF/";
            if (file.findChild("META-INF") != null) {
                return path;
            }
            defaultPath = path;
        }
        return defaultPath;
    }

    private static void createBatchXmlInWriteCommandAction(final @NotNull Module module, final @NotNull String path, final @NotNull String fileTemplate, final Properties properties) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/batch/config/BatchFrameworkType", "createBatchXmlInWriteCommandAction"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/batch/config/BatchFrameworkType", "createBatchXmlInWriteCommandAction"));
        }
        if (fileTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTemplate", "com/intellij/batch/config/BatchFrameworkType", "createBatchXmlInWriteCommandAction"));
        }
        new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

            protected void run() {
                try {
                    FileTemplate template;
                    File configFile = new File(FileUtil.toSystemDependentName((String)path));
                    if (!configFile.exists() && (template = FileTemplateManager.getInstance((Project)module.getProject()).getJ2eeTemplate(fileTemplate)) != null) {
                        FileUtil.createIfDoesntExist((File)configFile);
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configFile);
                        if (file != null) {
                            String text = template.getText(properties);
                            VfsUtil.saveText((VirtualFile)file, (String)text);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.execute();
    }

    private class MyGenerateConfigurable
    extends FrameworkSupportInModuleConfigurable {
        private JCheckBox myCreateBatchXml = new JCheckBox("Create batch.xml");
        private JCheckBox myCreateSampleJobXml = new JCheckBox("Create Sample Job Xml");

        private MyGenerateConfigurable() {
        }

        public JComponent createComponent() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
            panel.add((Component)this.myCreateBatchXml, gc);
            panel.add((Component)this.myCreateSampleJobXml, gc);
            return panel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/batch/config/BatchFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/batch/config/BatchFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            if (modifiableModelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/batch/config/BatchFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            Project project = module.getProject();
            if (this.myCreateBatchXml.isSelected()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    if (rootModel == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/batch/config/BatchFrameworkType$MyGenerateConfigurable", "lambda$addSupport$0"));
                    }
                    if (module == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/batch/config/BatchFrameworkType$MyGenerateConfigurable", "lambda$addSupport$0"));
                    }
                    String path = BatchFrameworkType.getMetaInfPath(rootModel);
                    if (path != null) {
                        String batchXmlPath = VfsUtilCore.urlToPath((String)(path + "batch.xml"));
                        BatchFrameworkType.createBatchXmlInWriteCommandAction(module, batchXmlPath, "batch.xml", new Properties());
                    }
                });
            }
            if (this.myCreateSampleJobXml.isSelected()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    if (rootModel == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/batch/config/BatchFrameworkType$MyGenerateConfigurable", "lambda$addSupport$1"));
                    }
                    if (module == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/batch/config/BatchFrameworkType$MyGenerateConfigurable", "lambda$addSupport$1"));
                    }
                    String path = BatchFrameworkType.getMetaInfPath(rootModel);
                    if (path != null) {
                        String batchXmlPath = VfsUtilCore.urlToPath((String)(path + "batch-jobs" + "/" + "job.xml"));
                        Properties properties = new Properties();
                        properties.setProperty("JOB_ID", "myJob");
                        BatchFrameworkType.createBatchXmlInWriteCommandAction(module, batchXmlPath, "job.xml", properties);
                    }
                });
            }
        }

        public CustomLibraryDescription createLibraryDescription() {
            return DownloadableLibraryService.getInstance().createDescriptionForType(BatchFrameworkType.this.getLibraryTypeClass());
        }
    }
}

