/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class GradleRunnerConfigurable
extends BaseConfigurable {
    private JPanel myMainPanel;
    private JBCheckBox myGradleAwareMakeCheckBox;
    private ComboBox myPreferredTestRunner;
    private static final TestRunnerItem[] TEST_RUNNER_ITEMS = new TestRunnerItem[]{new TestRunnerItem(GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER), new TestRunnerItem(GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER), new TestRunnerItem(GradleSystemRunningSettings.PreferredTestRunner.CHOOSE_PER_TEST)};

    public GradleRunnerConfigurable() {
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return GradleBundle.message("gradle.runner", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.project.gradle.running";
    }

    public void apply() throws ConfigurationException {
        boolean gradleMakeEnabled = this.myGradleAwareMakeCheckBox.isSelected();
        GradleSystemRunningSettings settings = GradleSystemRunningSettings.getInstance();
        settings.setUseGradleAwareMake(gradleMakeEnabled);
        settings.setPreferredTestRunner(((TestRunnerItem)this.myPreferredTestRunner.getSelectedItem()).value);
    }

    public void reset() {
        GradleSystemRunningSettings settings = GradleSystemRunningSettings.getInstance();
        TestRunnerItem item = GradleRunnerConfigurable.getItem(settings.getLastPreferredTestRunner());
        this.myPreferredTestRunner.setSelectedItem((Object)item);
        boolean gradleMakeEnabled = settings.isUseGradleAwareMake();
        this.enableGradleMake(gradleMakeEnabled);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        GradleSystemRunningSettings uiSettings = new GradleSystemRunningSettings();
        TestRunnerItem selectedItem = (TestRunnerItem)this.myPreferredTestRunner.getSelectedItem();
        GradleSystemRunningSettings.PreferredTestRunner preferredTestRunner = selectedItem == null ? GradleSystemRunningSettings.PreferredTestRunner.CHOOSE_PER_TEST : selectedItem.value;
        uiSettings.setPreferredTestRunner(preferredTestRunner);
        uiSettings.setUseGradleAwareMake(this.myGradleAwareMakeCheckBox.isSelected());
        GradleSystemRunningSettings settings = GradleSystemRunningSettings.getInstance();
        return !settings.equals(uiSettings);
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.myGradleAwareMakeCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.use.gradle.aware.make", new Object[0]));
        this.myGradleAwareMakeCheckBox.addActionListener(e -> this.enableGradleMake(this.myGradleAwareMakeCheckBox.isSelected()));
        this.myPreferredTestRunner = new ComboBox((Object[])GradleRunnerConfigurable.getItems());
    }

    private void enableGradleMake(boolean enable) {
        this.myGradleAwareMakeCheckBox.setSelected(enable);
        this.myPreferredTestRunner.setEnabled(!enable);
    }

    private static TestRunnerItem getItem(GradleSystemRunningSettings.PreferredTestRunner preferredTestRunner) {
        for (TestRunnerItem item : GradleRunnerConfigurable.getItems()) {
            if (item.value != preferredTestRunner) continue;
            return item;
        }
        return null;
    }

    private static TestRunnerItem[] getItems() {
        return TEST_RUNNER_ITEMS;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ComboBox comboBox = this.myPreferredTestRunner;
        jPanel.add((Component)comboBox, new GridConstraints(2, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 4, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("<html>Run tests using:</html>");
        jPanel.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 5, 8, 0, 3, 0, null, null, null));
        JBCheckBox jBCheckBox = this.myGradleAwareMakeCheckBox;
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    static class TestRunnerItem {
        GradleSystemRunningSettings.PreferredTestRunner value;

        public TestRunnerItem(GradleSystemRunningSettings.PreferredTestRunner value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestRunnerItem)) {
                return false;
            }
            TestRunnerItem item = (TestRunnerItem)o;
            return this.value == item.value;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value});
        }

        public String toString() {
            return GradleBundle.message("gradle.preferred_test_runner." + (this.value == null ? "CHOOSE_PER_TEST" : this.value.name()), new Object[0]);
        }
    }
}

