/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleImplicitContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;

public class GradleTaskContributor
implements GradleMethodContextContributor {
    @Override
    public void process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (methodCallInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallInfo", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "process"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "process"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "process"));
        }
        if (methodCallInfo.isEmpty()) {
            return;
        }
        if (methodCallInfo.size() == 1) {
            if (GradleResolverUtil.isLShiftElement(place.getParent())) {
                GradleResolverUtil.addImplicitVariable(processor, state, place, "org.gradle.api.Task");
            }
        } else if (methodCallInfo.size() == 2) {
            if (place.getParent().getParent() instanceof GrCommandArgumentList) {
                GradleTaskContributor.processTaskAddition(methodCallInfo.get(0), "org.gradle.api.tasks.TaskContainer", processor, state, place);
            } else {
                GradleTaskContributor.processTaskTypeParameter(methodCallInfo.get(0), processor, state, place);
            }
            GradleImplicitContributor.processImplicitDeclarations(processor, state, place);
        } else if (methodCallInfo.size() >= 3) {
            GradleTaskContributor.processTaskTypeParameter(methodCallInfo.get(0), processor, state, place);
            GradleImplicitContributor.processImplicitDeclarations(processor, state, place);
            if (place.getText().equals("sourceSets") && StringUtil.startsWith((CharSequence)methodCallInfo.get(0), (CharSequence)"sourceSets.")) {
                GradleResolverUtil.addImplicitVariable(processor, state, place, "org.gradle.api.tasks.SourceSetContainer");
            }
            if (place.getText().equals("distributions") && StringUtil.startsWith((CharSequence)methodCallInfo.get(0), (CharSequence)"distributions.")) {
                GradleResolverUtil.addImplicitVariable(processor, state, place, "org.gradle.api.distribution.DistributionContainer");
            }
        }
    }

    private static void processTaskTypeParameter(@NotNull String methodCall, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "processTaskTypeParameter"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "processTaskTypeParameter"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "processTaskTypeParameter"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "processTaskTypeParameter"));
        }
        int taskTypeParameterLevel = 3;
        PsiElement psiElement = GradleResolverUtil.findParent(place, 3);
        if (psiElement instanceof GrMethodCallExpression) {
            GrMethodCallExpression callExpression = (GrMethodCallExpression)psiElement;
            GrArgumentList argumentList = callExpression.getArgumentList();
            if (argumentList.getAllArguments().length > 0) {
                for (GroovyPsiElement argument : argumentList.getAllArguments()) {
                    if (!(argument instanceof GrNamedArgument)) continue;
                    GrNamedArgument namedArgument = (GrNamedArgument)argument;
                    GrExpression grExpression = namedArgument.getExpression();
                    PsiType psiType = null;
                    if (grExpression != null) {
                        psiType = GradleResolverUtil.getTypeOf(grExpression);
                    }
                    if (!(psiType instanceof PsiImmediateClassType)) continue;
                    PsiImmediateClassType immediateClassType = (PsiImmediateClassType)psiType;
                    for (PsiType type : immediateClassType.getParameters()) {
                        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
                        GradleResolverUtil.processDeclarations(methodCall, psiManager, processor, state, place, TypesUtil.getQualifiedName((PsiType)type));
                    }
                }
            } else {
                GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
                GradleResolverUtil.processDeclarations(psiManager, processor, state, place, "org.gradle.api.Task");
            }
        }
    }

    private static void processTaskAddition(@NotNull String name, @NotNull String handlerClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "processTaskAddition"));
        }
        if (handlerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerClass", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "processTaskAddition"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "processTaskAddition"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "processTaskAddition"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleTaskContributor", "processTaskAddition"));
        }
        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        PsiClass psiClass = psiManager.findClassWithCache(handlerClass, place.getResolveScope());
        if (psiClass == null) {
            return;
        }
        GrLightMethodBuilder builder = new GrLightMethodBuilder(place.getManager(), name);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getManager().getProject());
        PsiArrayType type = new PsiArrayType((PsiType)factory.createTypeByFQClassName("java.lang.Object", place.getResolveScope()));
        builder.addParameter((GrParameter)new GrLightParameter("taskInfo", (PsiType)type, (PsiElement)builder));
        PsiClassType retType = factory.createTypeByFQClassName("java.lang.String", place.getResolveScope());
        builder.setReturnType((PsiType)retType);
        processor.execute((PsiElement)builder, state);
        GrMethodCall call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        if (call == null) {
            return;
        }
        GrArgumentList args = call.getArgumentList();
        int argsCount = GradleResolverUtil.getGrMethodArumentsCount(args);
        ++argsCount;
        for (PsiMethod method : psiClass.findMethodsByName("create", false)) {
            if (method.getParameterList().getParametersCount() != argsCount) continue;
            builder.setNavigationElement((PsiElement)method);
        }
    }
}

