/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleNotification {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Gradle Notification Group");
    @NotNull
    private final Project myProject;

    @NotNull
    public static GradleNotification getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "getInstance"));
        }
        GradleNotification gradleNotification = (GradleNotification)ServiceManager.getService((Project)project, GradleNotification.class);
        if (gradleNotification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "getInstance"));
        }
        return gradleNotification;
    }

    public GradleNotification(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "<init>"));
        }
        this.myProject = project;
    }

    public void showBalloon(@NotNull String title, @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "showBalloon"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "showBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "showBalloon"));
        }
        NOTIFICATION_GROUP.createNotification(title, message, type, listener).notify(this.myProject);
    }
}

