/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.google.common.collect.Multimap;
import com.google.gson.GsonBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PathsList;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import groovy.lang.GroovyObject;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.model.ExtIdeaContentRoot;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataService;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.builder.ModelBuildScriptClasspathBuilderImpl;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerFactory;

@Order(value=0x7FFFFFFF)
public class BaseGradleProjectResolverExtension
implements GradleProjectResolverExtension {
    private static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance(BaseGradleProjectResolverExtension.class);
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    @NotNull
    private ProjectResolverContext resolverCtx;
    @NotNull
    private final BaseProjectImportErrorHandler myErrorHandler = new BaseProjectImportErrorHandler();

    @Override
    public void setProjectResolverContext(@NotNull ProjectResolverContext projectResolverContext) {
        if (projectResolverContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectResolverContext", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "setProjectResolverContext"));
        }
        this.resolverCtx = projectResolverContext;
    }

    @Override
    public void setNext(@NotNull GradleProjectResolverExtension next) {
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "setNext"));
        }
    }

    @Override
    @Nullable
    public GradleProjectResolverExtension getNext() {
        return null;
    }

    @Override
    @NotNull
    public ProjectData createProject() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        IdeaProject ideaProject = this.resolverCtx.getModels().getIdeaProject();
        ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, ideaProject.getName(), projectDirPath, projectDirPath);
        if (projectData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "createProject"));
        }
        return projectData;
    }

    @Override
    @NotNull
    public JavaProjectData createJavaProjectData() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        IdeaProject ideaProject = this.resolverCtx.getModels().getIdeaProject();
        JavaProjectData javaProjectData = new JavaProjectData(GradleConstants.SYSTEM_ID, projectDirPath + "/build/classes");
        javaProjectData.setJdkVersion(ideaProject.getJdkName());
        LanguageLevel resolvedLanguageLevel = null;
        String languageLevel = ideaProject.getLanguageLevel().getLevel();
        for (LanguageLevel level : LanguageLevel.values()) {
            if (!level.name().equals(languageLevel)) continue;
            resolvedLanguageLevel = level;
            break;
        }
        if (resolvedLanguageLevel != null) {
            javaProjectData.setLanguageLevel(resolvedLanguageLevel);
        } else {
            javaProjectData.setLanguageLevel(languageLevel);
        }
        JavaProjectData javaProjectData2 = javaProjectData;
        if (javaProjectData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "createJavaProjectData"));
        }
        return javaProjectData2;
    }

    @Override
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProject", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateProjectExtraModels"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateProjectExtraModels"));
        }
        ExternalProject externalProject = this.resolverCtx.getExtraProject(ExternalProject.class);
        if (externalProject != null) {
            ideProject.createChild(ExternalProjectDataService.KEY, (Object)externalProject);
            ((ProjectData)ideProject.getData()).setDescription(externalProject.getDescription());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        ModuleData mainModuleData;
        DataNode<ModuleData> mainModuleNode;
        block19: {
            if (gradleModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "createModule"));
            }
            if (projectDataNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataNode", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "createModule"));
            }
            mainModuleNode = GradleProjectResolverUtil.createMainModule(this.resolverCtx, gradleModule, projectDataNode);
            mainModuleData = (ModuleData)mainModuleNode.getData();
            String mainModuleConfigPath = mainModuleData.getLinkedExternalProjectPath();
            String mainModuleFileDirectoryPath = mainModuleData.getModuleFileDirectoryPath();
            ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
            if (!this.resolverCtx.isResolveModulePerSourceSet() || externalProject == null) {
                try {
                    IdeaJavaLanguageSettings languageSettings = gradleModule.getJavaLanguageSettings();
                    if (languageSettings == null) break block19;
                    if (languageSettings.getLanguageLevel() != null) {
                        mainModuleData.setSourceCompatibility(languageSettings.getLanguageLevel().toString());
                    }
                    if (languageSettings.getTargetBytecodeVersion() != null) {
                        mainModuleData.setTargetCompatibility(languageSettings.getTargetBytecodeVersion().toString());
                    }
                }
                catch (UnsupportedMethodException languageSettings) {
                    // empty catch block
                }
            } else {
                String gradlePath = gradleModule.getGradleProject().getPath();
                boolean isRootModule = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath);
                String[] moduleGroup = isRootModule ? new String[]{mainModuleData.getInternalName()} : (String[])ArrayUtil.remove((Object[])gradlePath.split(":"), (int)0);
                mainModuleData.setIdeModuleGroup(isRootModule ? null : moduleGroup);
                for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
                    String moduleId = GradleProjectResolverUtil.getModuleId(externalProject, sourceSet);
                    String moduleExternalName = gradleModule.getName() + ":" + sourceSet.getName();
                    String moduleInternalName = BaseGradleProjectResolverExtension.getInternalModuleName(gradleModule, sourceSet.getName());
                    GradleSourceSetData sourceSetData = new GradleSourceSetData(moduleId, moduleExternalName, moduleInternalName, mainModuleFileDirectoryPath, mainModuleConfigPath);
                    sourceSetData.setGroup(externalProject.getGroup());
                    sourceSetData.setVersion(externalProject.getVersion());
                    sourceSetData.setIdeModuleGroup(moduleGroup);
                    sourceSetData.setSourceCompatibility(sourceSet.getSourceCompatibility());
                    sourceSetData.setTargetCompatibility(sourceSet.getTargetCompatibility());
                    THashSet artifacts = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.FILE_HASHING_STRATEGY);
                    if ("main".equals(sourceSet.getName())) {
                        Set defaultArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("default");
                        if (defaultArtifacts != null) {
                            artifacts.addAll(defaultArtifacts);
                        }
                        if (externalProject.getArtifactsByConfiguration().get("archives") != null) {
                            HashSet archivesArtifacts = ContainerUtil.newHashSet((Iterable)((Iterable)externalProject.getArtifactsByConfiguration().get("archives")));
                            Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                            if (testsArtifacts != null) {
                                archivesArtifacts.removeAll(testsArtifacts);
                            }
                            artifacts.addAll(archivesArtifacts);
                        }
                    } else if ("test".equals(sourceSet.getName())) {
                        sourceSetData.setProductionModuleId(BaseGradleProjectResolverExtension.getInternalModuleName(gradleModule, "main"));
                        Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                        if (testsArtifacts != null) {
                            artifacts.addAll(testsArtifacts);
                        }
                    }
                    artifacts.addAll(sourceSet.getArtifacts());
                    sourceSetData.setArtifacts(ContainerUtil.newArrayList((Iterable)artifacts));
                    DataNode sourceSetDataNode = mainModuleNode.createChild(GradleSourceSetData.KEY, (Object)sourceSetData);
                    Map sourceSetMap = (Map)projectDataNode.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
                    assert (sourceSetMap != null);
                    sourceSetMap.put(moduleId, Pair.create((Object)sourceSetDataNode, (Object)sourceSet));
                }
            }
        }
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        if (StringUtil.equals((CharSequence)mainModuleData.getLinkedExternalProjectPath(), (CharSequence)projectData.getLinkedExternalProjectPath())) {
            projectData.setGroup(mainModuleData.getGroup());
            projectData.setVersion(mainModuleData.getVersion());
        }
        DataNode<ModuleData> dataNode = mainModuleNode;
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "createModule"));
        }
        return dataNode;
    }

    @NotNull
    private static String getInternalModuleName(@NotNull IdeaModule gradleModule, @NotNull String sourceSetName) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getInternalModuleName"));
        }
        if (sourceSetName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSetName", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getInternalModuleName"));
        }
        String string = PathUtilRt.suggestFileName((String)(gradleModule.getName() + "_" + sourceSetName), (boolean)true, (boolean)false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getInternalModuleName"));
        }
        return string;
    }

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleExtraModels"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleExtraModels"));
        }
        BuildScriptClasspathModel buildScriptClasspathModel = this.resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class);
        List classpathEntries = buildScriptClasspathModel != null ? ContainerUtil.map((Collection)buildScriptClasspathModel.getClasspath(), (Function)new Function<ClasspathEntryModel, BuildScriptClasspathData.ClasspathEntry>(){

            public BuildScriptClasspathData.ClasspathEntry fun(ClasspathEntryModel model) {
                return new BuildScriptClasspathData.ClasspathEntry(model.getClasses(), model.getSources(), model.getJavadoc());
            }
        }) : ContainerUtil.emptyList();
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        buildScriptClasspathData.setGradleHomeDir(buildScriptClasspathModel != null ? buildScriptClasspathModel.getGradleHomeDir() : null);
        ideModule.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
    }

    @Override
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        DomainObjectSet contentRoots;
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleContentRoots"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleContentRoots"));
        }
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            BaseGradleProjectResolverExtension.processSourceSets(externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    if (dataNode == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNode", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$2", "process"));
                    }
                    if (sourceSet == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSet", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$2", "process"));
                    }
                    for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                        ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                        ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                        for (File file : sourceDirectorySet.getSrcDirs()) {
                            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, file.getAbsolutePath());
                            ideContentRoot.storePath(sourceType, file.getAbsolutePath());
                            dataNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
                        }
                    }
                }
            });
        }
        if ((contentRoots = gradleModule.getContentRoots()) == null) {
            return;
        }
        for (IdeaContentRoot gradleContentRoot : contentRoots) {
            Set excluded;
            File rootDirectory;
            if (gradleContentRoot == null || (rootDirectory = gradleContentRoot.getRootDirectory()) == null) continue;
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, rootDirectory.getAbsolutePath());
            if (externalProject == null) {
                BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.SOURCE, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getSourceDirectories());
                BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.TEST, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getTestDirectories());
                if (gradleContentRoot instanceof ExtIdeaContentRoot) {
                    ExtIdeaContentRoot extIdeaContentRoot = (ExtIdeaContentRoot)gradleContentRoot;
                    BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.RESOURCE, (Iterable<? extends IdeaSourceDirectory>)extIdeaContentRoot.getResourceDirectories());
                    BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.TEST_RESOURCE, (Iterable<? extends IdeaSourceDirectory>)extIdeaContentRoot.getTestResourceDirectories());
                }
            }
            if ((excluded = gradleContentRoot.getExcludeDirectories()) != null) {
                for (File file : excluded) {
                    ideContentRoot.storePath(ExternalSystemSourceType.EXCLUDED, file.getAbsolutePath());
                }
            }
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    private static void processSourceSets(@NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> ideModule, @NotNull SourceSetsProcessor processor) {
        if (externalProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProject", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "processSourceSets"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "processSourceSets"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "processSourceSets"));
        }
        HashMap sourceSetsMap = ContainerUtil.newHashMap();
        for (DataNode dataNode : ExternalSystemApiUtil.findAll(ideModule, GradleSourceSetData.KEY)) {
            sourceSetsMap.put(((GradleSourceSetData)((Object)dataNode.getData())).getId(), dataNode);
        }
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            DataNode moduleDataNode;
            if (sourceSet == null || sourceSet.getSources().isEmpty()) continue;
            String moduleId = GradleProjectResolverUtil.getModuleId(externalProject, sourceSet);
            DataNode dataNode = moduleDataNode = sourceSetsMap.isEmpty() ? ideModule : (DataNode)sourceSetsMap.get(moduleId);
            if (moduleDataNode == null) continue;
            processor.process((DataNode<? extends ModuleData>)moduleDataNode, sourceSet);
        }
    }

    @Override
    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleCompileOutputSettings"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleCompileOutputSettings"));
        }
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (this.resolverCtx.isResolveModulePerSourceSet() && externalProject != null) {
            DataNode projectDataNode = ideModule.getDataNode(ProjectKeys.PROJECT);
            assert (projectDataNode != null);
            final Map moduleOutputsMap = (Map)projectDataNode.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
            assert (moduleOutputsMap != null);
            BaseGradleProjectResolverExtension.processSourceSets(externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    if (dataNode == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNode", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$3", "process"));
                    }
                    if (sourceSet == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSet", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$3", "process"));
                    }
                    for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                        Map map;
                        ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                        ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                        ModuleData moduleData = (ModuleData)dataNode.getData();
                        File outputDir = sourceDirectorySet.getOutputDir();
                        moduleData.setCompileOutputPath(sourceType, outputDir.getAbsolutePath());
                        moduleData.setInheritProjectCompileOutputPath(sourceDirectorySet.isCompilerOutputPathInherited());
                        File gradleOutputDir = sourceDirectorySet.getGradleOutputDir();
                        String gradleOutputPath = moduleData.getCompileOutputPath(sourceType);
                        if (!gradleOutputDir.getPath().equals(outputDir.getPath())) {
                            gradleOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)gradleOutputDir.getAbsolutePath());
                            moduleOutputsMap.put(gradleOutputPath, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                        }
                        if ((map = (Map)dataNode.getUserData(GradleProjectResolver.GRADLE_OUTPUTS)) == null) {
                            map = ContainerUtil.newHashMap();
                            dataNode.putUserData(GradleProjectResolver.GRADLE_OUTPUTS, (Object)map);
                        }
                        map.put(sourceType, gradleOutputPath);
                    }
                }
            });
            return;
        }
        IdeaCompilerOutput moduleCompilerOutput = gradleModule.getCompilerOutput();
        File buildDir = null;
        try {
            buildDir = gradleModule.getGradleProject().getBuildDirectory();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            // empty catch block
        }
        HashMap compileOutputPaths = ContainerUtil.newHashMap();
        boolean inheritOutputDirs = moduleCompilerOutput != null && moduleCompilerOutput.getInheritOutputDirs();
        ModuleData moduleData = (ModuleData)ideModule.getData();
        if (moduleCompilerOutput != null) {
            File classesOutputDir = BaseGradleProjectResolverExtension.selectCompileOutputDir(moduleCompilerOutput.getOutputDir(), externalProject, "classes/main");
            compileOutputPaths.put(ExternalSystemSourceType.SOURCE, classesOutputDir);
            File resourcesOutputDir = BaseGradleProjectResolverExtension.selectCompileOutputDir(moduleCompilerOutput.getOutputDir(), externalProject, "resources/main");
            compileOutputPaths.put(ExternalSystemSourceType.RESOURCE, resourcesOutputDir);
            File testClassesOuputDir = BaseGradleProjectResolverExtension.selectCompileOutputDir(moduleCompilerOutput.getTestOutputDir(), externalProject, "classes/test");
            compileOutputPaths.put(ExternalSystemSourceType.TEST, testClassesOuputDir);
            File testResourcesOutputDir = BaseGradleProjectResolverExtension.selectCompileOutputDir(moduleCompilerOutput.getTestOutputDir(), externalProject, "resources/test");
            compileOutputPaths.put(ExternalSystemSourceType.TEST_RESOURCE, testResourcesOutputDir);
        }
        for (Map.Entry sourceTypeFileEntry : compileOutputPaths.entrySet()) {
            File outputPath = (File)ObjectUtils.chooseNotNull(sourceTypeFileEntry.getValue(), (Object)buildDir);
            if (outputPath == null) continue;
            moduleData.setCompileOutputPath((ExternalSystemSourceType)sourceTypeFileEntry.getKey(), outputPath.getAbsolutePath());
        }
        moduleData.setInheritProjectCompileOutputPath(inheritOutputDirs);
    }

    @Nullable
    private static File selectCompileOutputDir(@Nullable File outputDir, @Nullable ExternalProject externalProject, String path) {
        if (outputDir != null || externalProject == null) {
            return outputDir;
        }
        return new File(externalProject.getBuildDir(), path);
    }

    @Override
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, final @NotNull DataNode<ProjectData> ideProject) {
        ExternalSystemTaskId taskId;
        Project project;
        List dependencies;
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleDependencies"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleDependencies"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleDependencies"));
        }
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            final Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
            final Map artifactsMap = (Map)ideProject.getUserData(GradleProjectResolver.CONFIGURATION_ARTIFACTS);
            assert (artifactsMap != null);
            if (this.resolverCtx.isResolveModulePerSourceSet()) {
                assert (sourceSetMap != null);
                BaseGradleProjectResolverExtension.processSourceSets(externalProject, ideModule, new SourceSetsProcessor(){

                    @Override
                    public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                        if (dataNode == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNode", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$4", "process"));
                        }
                        if (sourceSet == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSet", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$4", "process"));
                        }
                        GradleProjectResolverUtil.buildDependencies(BaseGradleProjectResolverExtension.this.resolverCtx, sourceSetMap, artifactsMap, dataNode, sourceSet.getDependencies(), (DataNode<ProjectData>)ideProject);
                    }
                });
                return;
            }
        }
        if ((dependencies = gradleModule.getDependencies().getAll()) == null) {
            return;
        }
        ArrayList orphanModules = ContainerUtil.newArrayList();
        for (IdeaDependency dependency : dependencies) {
            ModuleDependencyData d;
            if (dependency == null) continue;
            DependencyScope scope = BaseGradleProjectResolverExtension.parseScope(dependency.getScope());
            if (dependency instanceof IdeaModuleDependency) {
                d = BaseGradleProjectResolverExtension.buildDependency(this.resolverCtx.getSettings(), ideModule, (IdeaModuleDependency)dependency, ideProject);
                d.setExported(dependency.getExported());
                if (scope != null) {
                    d.setScope(scope);
                }
                ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)d);
                ModuleData targetModule = (ModuleData)d.getTarget();
                if (!targetModule.getId().isEmpty() || !targetModule.getLinkedExternalProjectPath().isEmpty()) continue;
                orphanModules.add(targetModule.getExternalName());
                continue;
            }
            if (!(dependency instanceof IdeaSingleEntryLibraryDependency)) continue;
            d = this.buildDependency(gradleModule, ideModule, (IdeaSingleEntryLibraryDependency)dependency, ideProject);
            d.setExported(dependency.getExported());
            if (scope != null) {
                d.setScope(scope);
            }
            ideModule.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)d);
        }
        if (!orphanModules.isEmpty() && (project = (taskId = this.resolverCtx.getExternalSystemTaskId()).findProject()) != null) {
            String msg = "Can't find the following module" + (orphanModules.size() > 1 ? "s" : "") + ": " + StringUtil.join((Collection)orphanModules, (String)", ") + "\nIt can be caused by composite build configuration inside your *.gradle scripts with Gradle version older than 3.3.\nTry Gradle 3.3 or better or enable 'Create separate module per source set' option";
            NotificationData notification = new NotificationData("Gradle project structure problems", msg, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(taskId.getProjectSystemId(), notification);
        }
    }

    @Override
    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        boolean isFlatProject;
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleTasks"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleTasks"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleTasks"));
        }
        ArrayList tasks = ContainerUtil.newArrayList();
        String moduleConfigPath = ((ModuleData)ideModule.getData()).getLinkedExternalProjectPath();
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        String rootProjectPath = ((ProjectData)ideProject.getData()).getLinkedExternalProjectPath();
        boolean bl = isFlatProject = !FileUtil.isAncestor((String)rootProjectPath, (String)moduleConfigPath, (boolean)false);
        if (externalProject != null) {
            for (ExternalTask task : externalProject.getTasks().values()) {
                String taskName = isFlatProject ? task.getQName() : task.getName();
                String taskGroup = task.getGroup();
                if (taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
                String taskPath = isFlatProject ? rootProjectPath : moduleConfigPath;
                TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, taskPath, task.getDescription());
                taskData.setGroup(taskGroup);
                taskData.setType(task.getType());
                ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
                taskData.setInherited(StringUtil.equals((CharSequence)task.getName(), (CharSequence)task.getQName()));
                tasks.add(taskData);
            }
            ArrayList arrayList = tasks;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleTasks"));
            }
            return arrayList;
        }
        for (GradleTask task : gradleModule.getGradleProject().getTasks()) {
            String taskName = task.getName();
            String taskGroup = BaseGradleProjectResolverExtension.getTaskGroup(task);
            if (taskName == null || taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, moduleConfigPath, task.getDescription());
            taskData.setGroup(taskGroup);
            ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
            tasks.add(taskData);
        }
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateModuleTasks"));
        }
        return arrayList;
    }

    @Nullable
    private static String getTaskGroup(GradleTask task) {
        String taskGroup;
        try {
            taskGroup = task.getGroup();
        }
        catch (UnsupportedMethodException e) {
            taskGroup = null;
        }
        return taskGroup;
    }

    @Override
    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set result = ContainerUtil.set((Object[])new Class[]{GradleBuild.class, ModuleExtendedModel.class});
        result.add(BuildScriptClasspathModel.class);
        result.add(ExternalProject.class);
        Set set = result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getExtraProjectModelClasses"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Class> getToolingExtensionsClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{ExternalSystemSourceType.class, ProjectImportAction.class, ModelBuildScriptClasspathBuilderImpl.class, Multimap.class, GsonBuilder.class, ShortTypeHandling.class});
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getToolingExtensionsClasses"));
        }
        return set;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            List hosts;
            ArrayList extraJvmArgs = ContainerUtil.newArrayList();
            HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
            if (!StringUtil.isEmpty((String)httpConfigurable.PROXY_EXCEPTIONS) && !(hosts = StringUtil.split((String)httpConfigurable.PROXY_EXCEPTIONS, (String)",")).isEmpty()) {
                String nonProxyHosts = StringUtil.join((Collection)hosts, (Function)StringUtil.TRIMMER, (String)"|");
                extraJvmArgs.add(Pair.pair((Object)"http.nonProxyHosts", (Object)nonProxyHosts));
                extraJvmArgs.add(Pair.pair((Object)"https.nonProxyHosts", (Object)nonProxyHosts));
            }
            if (httpConfigurable.USE_HTTP_PROXY && StringUtil.isNotEmpty((String)httpConfigurable.getProxyLogin())) {
                extraJvmArgs.add(Pair.pair((Object)"http.proxyUser", (Object)httpConfigurable.getProxyLogin()));
                extraJvmArgs.add(Pair.pair((Object)"https.proxyUser", (Object)httpConfigurable.getProxyLogin()));
                String plainProxyPassword = httpConfigurable.getPlainProxyPassword();
                extraJvmArgs.add(Pair.pair((Object)"http.proxyPassword", (Object)plainProxyPassword));
                extraJvmArgs.add(Pair.pair((Object)"https.proxyPassword", (Object)plainProxyPassword));
            }
            extraJvmArgs.addAll(httpConfigurable.getJvmProperties(false, null));
            ArrayList arrayList = extraJvmArgs;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getExtraJvmArgs"));
            }
            return arrayList;
        }
        List<Pair<String, String>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getExtraJvmArgs"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getExtraCommandLineArgs() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getExtraCommandLineArgs"));
        }
        return list;
    }

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getUserFriendlyError"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getUserFriendlyError"));
        }
        ExternalSystemException externalSystemException = this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
        if (externalSystemException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "getUserFriendlyError"));
        }
        return externalSystemException;
    }

    @Override
    public void preImportCheck() {
    }

    @Override
    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String debuggerSetup, @NotNull Consumer<String> initScriptConsumer) {
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "enhanceTaskProcessing"));
        }
        if (initScriptConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initScriptConsumer", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "enhanceTaskProcessing"));
        }
        if (!StringUtil.isEmpty((String)debuggerSetup)) {
            String names = "[\"" + StringUtil.join(taskNames, (String)"\", \"") + "\"]";
            String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task instanceof JavaForkOptions && (" + names + ".contains(task.name) || " + names + ".contains(task.path))) {", "        def jvmArgs = task.jvmArgs.findAll{!it?.startsWith('-agentlib') && !it?.startsWith('-Xrunjdwp')}", "        jvmArgs << '" + debuggerSetup.trim() + '\'', "        task.jvmArgs jvmArgs", "    }}"};
            String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
            initScriptConsumer.consume((Object)script);
        }
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) throws ExecutionException {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "enhanceRemoteProcessing"));
        }
        PathsList classPath = parameters.getClassPath();
        ExternalSystemApiUtil.addBundle((PathsList)classPath, (String)"i18n.GradleBundle", GradleBundle.class);
        String toolingApiPath = PathManager.getJarPathForClass(ProjectConnection.class);
        if (toolingApiPath == null) {
            LOG.warn(GradleBundle.message("gradle.generic.text.error.jar.not.found", new Object[0]));
            throw new ExecutionException("Can't find gradle libraries");
        }
        File gradleJarsDir = new File(toolingApiPath).getParentFile();
        File[] gradleJars = gradleJarsDir.listFiles(FileFilters.filesWithExtension((String)"jar"));
        if (gradleJars == null) {
            LOG.warn(GradleBundle.message("gradle.generic.text.error.jar.not.found", new Object[0]));
            throw new ExecutionException("Can't find gradle libraries at " + gradleJarsDir.getAbsolutePath());
        }
        for (File jar : gradleJars) {
            classPath.add(jar.getAbsolutePath());
        }
        ArrayList additionalEntries = ContainerUtilRt.newArrayList();
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(GroovyObject.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(GsonBuilder.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(ExternalProject.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(JavaProjectData.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(LanguageLevel.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(StdModuleTypes.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(JavaModuleType.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(ModuleType.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(EmptyModuleType.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(ProjectImportAction.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(Init.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(Logger.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(Log4jLoggerFactory.class));
        for (String entry : additionalEntries) {
            classPath.add(entry);
        }
    }

    public void enhanceLocalProcessing(@NotNull List<URL> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "enhanceLocalProcessing"));
        }
    }

    private static void populateContentRoot(@NotNull ContentRootData contentRoot, @NotNull ExternalSystemSourceType type, @Nullable Iterable<? extends IdeaSourceDirectory> dirs) throws IllegalArgumentException {
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateContentRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "populateContentRoot"));
        }
        if (dirs == null) {
            return;
        }
        for (IdeaSourceDirectory ideaSourceDirectory : dirs) {
            ExternalSystemSourceType dirSourceType = type;
            try {
                if (ideaSourceDirectory.isGenerated() && !dirSourceType.isGenerated()) {
                    ExternalSystemSourceType generatedType = ExternalSystemSourceType.from((boolean)dirSourceType.isTest(), (boolean)ideaSourceDirectory.isGenerated(), (boolean)dirSourceType.isResource(), (boolean)dirSourceType.isExcluded());
                    dirSourceType = generatedType != null ? generatedType : dirSourceType;
                }
            }
            catch (UnsupportedMethodException e) {
                LOG.warn(e.getMessage());
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            catch (Throwable e) {
                LOG.debug(e);
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            contentRoot.storePath(dirSourceType, ideaSourceDirectory.getDirectory().getAbsolutePath());
        }
    }

    private static void printToolingProxyDiagnosticInfo(@Nullable Object obj) {
        if (!LOG.isDebugEnabled() || obj == null) {
            return;
        }
        LOG.debug(String.format("obj: %s", obj));
        Class<?> aClass = obj.getClass();
        LOG.debug(String.format("obj class: %s", aClass));
        LOG.debug(String.format("classloader: %s", aClass.getClassLoader()));
        for (Method m : aClass.getDeclaredMethods()) {
            LOG.debug(String.format("obj m: %s", m));
        }
        if (obj instanceof Proxy) {
            try {
                Field hField = ReflectionUtil.findField(obj.getClass(), null, (String)"h");
                hField.setAccessible(true);
                Object h = hField.get(obj);
                Field delegateField = ReflectionUtil.findField(h.getClass(), null, (String)"delegate");
                delegateField.setAccessible(true);
                Object delegate = delegateField.get(h);
                LOG.debug(String.format("delegate: %s", delegate));
                LOG.debug(String.format("delegate class: %s", delegate.getClass()));
                LOG.debug(String.format("delegate classloader: %s", delegate.getClass().getClassLoader()));
                for (Method m : delegate.getClass().getDeclaredMethods()) {
                    LOG.debug(String.format("delegate m: %s", m));
                }
            }
            catch (NoSuchFieldException e) {
                LOG.debug((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @Nullable
    private static DependencyScope parseScope(@Nullable IdeaDependencyScope scope) {
        if (scope == null) {
            return null;
        }
        String scopeAsString = scope.getScope();
        if (scopeAsString == null) {
            return null;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scopeAsString.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return null;
    }

    @NotNull
    private static ModuleDependencyData buildDependency(@Nullable GradleExecutionSettings executionSettings, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaModuleDependency dependency, @NotNull DataNode<ProjectData> ideProject) throws IllegalStateException {
        if (ownerModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
        }
        IdeaModule module = dependency.getDependencyModule();
        if (module == null) {
            if (executionSettings != null) {
                String moduleName = dependency.getTargetModuleName();
                ModuleData moduleData = executionSettings.getExecutionWorkspace().findModuleDataByName(moduleName);
                if (moduleData != null) {
                    ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData);
                    if (moduleDependencyData == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
                    }
                    return moduleDependencyData;
                }
                if (StringUtil.isNotEmpty((String)moduleName)) {
                    ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), new ModuleData("", GradleConstants.SYSTEM_ID, StdModuleTypes.JAVA.getId(), moduleName, "", ""));
                    if (moduleDependencyData == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
                    }
                    return moduleDependencyData;
                }
            }
            throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: referenced module is null", dependency));
        }
        String moduleName = module.getName();
        if (moduleName == null) {
            throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: referenced module name is undefined (module: '%s') ", dependency, module));
        }
        HashSet registeredModuleNames = ContainerUtilRt.newHashSet();
        Collection modulesDataNode = ExternalSystemApiUtil.getChildren(ideProject, (Key)ProjectKeys.MODULE);
        for (DataNode moduleDataNode : modulesDataNode) {
            String name = ((ModuleData)moduleDataNode.getData()).getExternalName();
            registeredModuleNames.add(name);
            if (!name.equals(moduleName)) continue;
            ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), (ModuleData)moduleDataNode.getData());
            if (moduleDependencyData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
            }
            return moduleDependencyData;
        }
        throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: no module with such name (%s) is found. Registered modules: %s", dependency, moduleName, registeredModuleNames));
    }

    @NotNull
    private LibraryDependencyData buildDependency(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaSingleEntryLibraryDependency dependency, @NotNull DataNode<ProjectData> ideProject) throws IllegalStateException {
        String libraryName;
        LibraryLevel level;
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
        }
        if (ownerModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerModule", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
        }
        File binaryPath = dependency.getFile();
        if (binaryPath == null) {
            throw new IllegalStateException(String.format("Can't parse external library dependency '%s'. Reason: it doesn't specify path to the binaries", dependency));
        }
        GradleModuleVersion moduleVersion = dependency.getGradleModuleVersion();
        boolean unresolved = binaryPath.getPath().startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
        if (moduleVersion == null) {
            level = LibraryLevel.MODULE;
            libraryName = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : "";
            if (unresolved) {
                int dependencyNameIndex;
                libraryName = binaryPath.getPath().substring(UNRESOLVED_DEPENDENCY_PREFIX.length());
                int i = libraryName.indexOf(32);
                if (i >= 0) {
                    i = CharArrayUtil.shiftForward((CharSequence)libraryName, (int)(i + 1), (String)" ");
                }
                if (i >= 0 && i < libraryName.length() && (i = libraryName.indexOf(32, dependencyNameIndex = i)) > 0) {
                    libraryName = String.format("%s-%s", libraryName.substring(dependencyNameIndex, i), libraryName.substring(i + 1));
                }
            }
        } else {
            level = LibraryLevel.PROJECT;
            libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            if (binaryPath.isFile()) {
                String libraryFileName = FileUtil.getNameWithoutExtension((File)binaryPath);
                String mavenLibraryFileName = String.format("%s-%s", moduleVersion.getName(), moduleVersion.getVersion());
                if (!mavenLibraryFileName.equals(libraryFileName)) {
                    Pattern pattern = Pattern.compile(moduleVersion.getName() + "-" + moduleVersion.getVersion() + "-(.*)");
                    Matcher matcher = pattern.matcher(libraryFileName);
                    if (matcher.matches()) {
                        String classifier = matcher.group(1);
                        libraryName = libraryName + ":" + classifier;
                    } else {
                        String artifactId = StringUtil.trimEnd((String)StringUtil.trimEnd((String)libraryFileName, (String)moduleVersion.getVersion()), (String)"-");
                        libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), artifactId, moduleVersion.getVersion());
                    }
                }
            }
        }
        if (StringUtil.isNotEmpty((String)libraryName) && !FileUtilRt.extensionEquals((String)binaryPath.getPath(), (String)"jar")) {
            libraryName = libraryName + ":" + FileUtilRt.getExtension((String)binaryPath.getPath());
        }
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, unresolved);
        if (!unresolved) {
            library.addPath(LibraryPathType.BINARY, binaryPath.getAbsolutePath());
        }
        File sourcePath = dependency.getSource();
        if (!unresolved && sourcePath != null) {
            library.addPath(LibraryPathType.SOURCE, sourcePath.getAbsolutePath());
        }
        if (!unresolved && sourcePath == null) {
            GradleProjectResolverUtil.attachGradleSdkSources(gradleModule, binaryPath, library, this.resolverCtx);
        }
        File javadocPath = dependency.getJavadoc();
        if (!unresolved && javadocPath != null) {
            library.addPath(LibraryPathType.DOC, javadocPath.getAbsolutePath());
        }
        if (level == LibraryLevel.PROJECT) {
            GradleProjectResolverUtil.linkProjectLibrary(ideProject, library);
        }
        LibraryDependencyData libraryDependencyData = new LibraryDependencyData((ModuleData)ownerModule.getData(), library, level);
        if (libraryDependencyData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension", "buildDependency"));
        }
        return libraryDependencyData;
    }

    private static interface SourceSetsProcessor {
        public void process(@NotNull DataNode<? extends ModuleData> var1, @NotNull ExternalSourceSet var2);
    }
}

